/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.spi.LogRecordFieldsProvider;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.impl.c4.C4_DataLineParser;
import com.azul.log.parser.impl.c4.C4_LogLineParserProvider;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.impl.c4.utils.C4_Utilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class C4_LogRecordFieldsProvider
implements LogRecordFieldsProvider {
    @Override
    public Field getFieldAtChar(Class<? extends LogRecord> recordClass, CharSequence plainText, int charIndex) {
        return this.getFieldAtChar(recordClass, plainText, charIndex, false);
    }

    private Field getFieldAtChar(Class<? extends LogRecord> recordClass, CharSequence plainText, int charIndex, boolean aliased) {
        LogLineWithTime logLineWithTime;
        if (plainText.length() == 0 || charIndex < 0 || charIndex >= plainText.length()) {
            return null;
        }
        char c = plainText.charAt(charIndex);
        if (Character.isWhitespace(c) || c == ':' || c == '[' || c == ']') {
            return null;
        }
        int idx = 0;
        while (Character.isWhitespace(plainText.charAt(idx))) {
            ++idx;
        }
        if (idx > 0) {
            plainText = plainText.subSequence(idx, plainText.length());
            charIndex -= idx;
        }
        if ((logLineWithTime = C4_LogParser.parseRawString(plainText)) == null) {
            return null;
        }
        C4_LogParser.DataLine line = C4_LogParser.DataLine.parse(logLineWithTime.getData());
        if (line == null) {
            return null;
        }
        Set<C4_LogLineParser> parsers = C4_LogLineParserProvider.getParsers(line);
        if (parsers == null) {
            return null;
        }
        if ((charIndex -= logLineWithTime.getDataStartIndex() + line.prefix.length() + 2) < 0) {
            return null;
        }
        int wordIndex = -1;
        for (C4_LogLineParser parser : parsers) {
            Field field;
            List<Field> aliasedFields;
            C4_Utilities.WordsList words;
            int num;
            List<Field> fields;
            if (!(parser instanceof C4_DataLineParser)) continue;
            C4_DataLineParser lineParser = (C4_DataLineParser)parser;
            String updatedDataLine = lineParser.handleKnownDelimitersInFields(line.data);
            if (!updatedDataLine.equals(line.data)) {
                line = new C4_LogParser.DataLine(line.prefix, updatedDataLine);
            }
            if ((fields = lineParser.getFields(num = (words = C4_Utilities.splitWords(line.data)).size())) == null) continue;
            List<Field> list = aliasedFields = aliased ? lineParser.getAliasedFields(num) : null;
            if (wordIndex < 0) {
                wordIndex = this.getWordIndex(charIndex, line);
            }
            Field field2 = field = aliasedFields == null ? null : aliasedFields.get(wordIndex);
            if (field == null) {
                field = fields.get(wordIndex);
            }
            if (field == null || !field.getDeclaringClass().isAssignableFrom(recordClass)) continue;
            return field;
        }
        return null;
    }

    private int getWordIndex(int charIndex, C4_LogParser.DataLine line) {
        int word_index = -1;
        boolean inWord = false;
        block4: for (int i = 0; i <= charIndex; ++i) {
            switch (line.data.charAt(i)) {
                case ' ': {
                    inWord = false;
                    continue block4;
                }
                case ':': {
                    inWord = false;
                    ++word_index;
                    continue block4;
                }
                default: {
                    if (inWord) continue block4;
                    inWord = true;
                    ++word_index;
                }
            }
        }
        return word_index;
    }

    @Override
    public List<LogRecordFieldsProvider.TextBounds> getFieldsBounds(Class<? extends LogRecord> recordClass, CharSequence plainText, Collection<Field> fields) {
        ArrayList<LogRecordFieldsProvider.TextBounds> result = new ArrayList<LogRecordFieldsProvider.TextBounds>();
        HashSet<Field> filedsSet = new HashSet<Field>(fields);
        int len = plainText.length();
        block0: for (int pos = 0; pos < len && !filedsSet.isEmpty(); ++pos) {
            Field f = this.getFieldAtChar(recordClass, plainText, pos, true);
            if (!filedsSet.remove(f)) continue;
            int start = pos;
            while (pos <= len) {
                char c;
                char c2 = c = pos == len ? (char)' ' : (char)plainText.charAt(pos);
                if (Character.isWhitespace(c) || c == ':' || c == ']') {
                    result.add(new LogRecordFieldsProvider.TextBounds(start, pos));
                    continue block0;
                }
                ++pos;
            }
        }
        return result;
    }
}

