/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.custom;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_LogLineParserProvider;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class C4_CustomLogLineParser
extends LogParserImpl<C4_ParserState> {
    public C4_CustomLogLineParser(LogModel model) {
        super(model, new C4_ParserState());
    }

    @Override
    protected LogLineWithTime parseLogLineImpl(CharSequence line) {
        return this.parse(line);
    }

    @Override
    protected List<LogRecord> getLogRecordsImpl(String data) throws ParserException {
        C4_LogParser.DataLine dataLine = C4_LogParser.DataLine.parse(data);
        List<LogRecord> records = this.parseLine(dataLine);
        return records;
    }

    private List<LogRecord> parseLine(C4_LogParser.DataLine dataLine) throws ParserException {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        Set<C4_LogLineParser> parsers = C4_LogLineParserProvider.getParsers(dataLine);
        if (parsers != null) {
            boolean processed = false;
            for (C4_LogLineParser parser : parsers) {
                C4_LogLineParser.DataLineParseResult result = parser.parseDataLine((C4_ParserState)this.state, dataLine);
                if (result == null) continue;
                processed = true;
                if (result == C4_LogLineParser.DataLineParseResult.DUMMY_RESULT) continue;
                records.add(result.record);
            }
            if (processed) {
                return records;
            }
        }
        return null;
    }

    private LogLineWithTime parse(CharSequence line) {
        if (line.length() == 0 || !Character.isDigit(line.charAt(0)) && line.charAt(0) != '[') {
            return null;
        }
        CharSequence absoluteTimestamp = null;
        CharSequence relativeTimestamp = null;
        int space_idx = 0;
        int data_start_idx = -1;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '[') {
                data_start_idx = i;
                break;
            }
            if (c == '-') {
                throw new RuntimeException("RN/VM custom log line should not have absolute timestamp");
            }
            if (c != '.') continue;
            int s = space_idx;
            space_idx = TextUtils.indexOf(line, ": ", i);
            if (space_idx == -1) {
                return null;
            }
            relativeTimestamp = line.subSequence(s, space_idx);
            data_start_idx = i = space_idx + 1;
        }
        return new LogLineWithTime(absoluteTimestamp, relativeTimestamp, data_start_idx, line);
    }
}

