/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_FieldTypes;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.advisor.LogLineInfo;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.support.FieldSetterSupport;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.utils.CommonUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

public final class C4_LogHeader {
    @GCHH(id="zing name")
    public String vm_name;
    @GCHH(id="zing release")
    public String vm_release;
    @GCHH(id="zst version")
    public String zst_version;
    @GCHH(id="zst api")
    public String get_azmem_api_version;
    @GCHH(id="os name")
    public String os_name;
    @GCHH(id="os release")
    public String os_release;
    @GCHH(id="hardware")
    public String hardware_type;
    @GCHH(id="ncpus")
    public C4_FieldTypes.CPUInfo cpu_info;
    @GCHH(id="tsc")
    public C4_FieldTypes.TSCInfo tsc_info;
    @GCHH(id="machine name")
    public String machine_name;
    @GCHH(id="model name")
    public String cpu_model;
    @GCHH(id="cpu part")
    public String cpu_part_number;
    @GCHH(id="physical id")
    public int max_cpu_id;
    @GCHH(id="zing vm running in container")
    public Boolean zing_vm_is_running_in_container;
    @GCHH(id="container engine")
    public String container_engine;
    @GCHH(id="container type")
    public String cg_type;
    @GCHH(id="active processor count")
    public double cg_active_processor_count;
    @GCHH(id="active processor count(precise)")
    public Double cg_active_processor_count_precise;
    @GCHH(id="available memory nodes")
    public String cg_available_memory_nodes;
    @GCHH(id="available cpus")
    public String cg_available_cpus;
    @GCHH(id="cpu quota, us", units=LogUnits.MICROSECONDS)
    public int cg_cpu_quota_us;
    @GCHH(id="cpu period, us", units=LogUnits.MICROSECONDS)
    public int cg_cpu_period_us;
    @GCHH(id="cpu shares")
    public int cg_cpu_shares;
    @GCHH(id="memory and swap limit, bytes", units=LogUnits.BYTES)
    public long cg_memory_and_swap_limit_bytes;
    @GCHH(id="memory limit, bytes", units=LogUnits.BYTES)
    public long cg_memory_limit_bytes;
    @GCHH(id="memory soft limit, bytes", units=LogUnits.BYTES)
    public long cg_memory_soft_limit_bytes;
    @GCHH(id="process id")
    public Integer current_process_id;
    @GCHH(id="sequence no.")
    public int sequence_number;
    @GCHH(id="system ram max", units=LogUnits.MEGABYTES)
    public Integer system_ram_total;
    @GCHH(id="system ram free", units=LogUnits.MEGABYTES)
    public int system_ram_free;
    @GCHH(id="linux memory max", units=LogUnits.MEGABYTES)
    public int reserve_at_config_linux_memory_max_mb;
    @GCHH(id="zing memory configuration policy")
    public String zmm_configuration_policy;
    @GCHH(id="zing memory partition size", units=LogUnits.MEGABYTES)
    public int system_zing_memory_config_system_zing_memory_total_mb;
    @GCHH(id="zing reservable max", units=LogUnits.MEGABYTES)
    public int system_zing_memory_config_max_reservable_mb;
    @GCHH(id="zing contingency max", units=LogUnits.MEGABYTES)
    public int system_zing_memory_config_max_contingency_mb;
    @GCHH(id="zing pause max", units=LogUnits.MEGABYTES)
    public int system_zing_memory_config_max_pause_mb;
    @GCHH(id="linux memory available", units=LogUnits.MEGABYTES)
    public int reserve_at_launch_linux_memory_available_mb;
    @GCHH(id="zing overall upper limit", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_overall_upper_limit_mb;
    @GCHH(id="zing total reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_total_reserved_mb;
    @GCHH(id="zing initial reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_initial_reserved_mb;
    @GCHH(id="zing reservable upper limit", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_upper_limit_reservable_mb;
    @GCHH(id="zing reservable reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_reserved_reservable_mb;
    @GCHH(id="zing reservable initial reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_initial_reserved_reservable_mb;
    @GCHH(id="zing contingency upper limit", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_upper_limit_contingency_mb;
    @GCHH(id="zing contingency reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_reserved_contingency_mb;
    @GCHH(id="zing contingency initial reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_initial_reserved_contingency_mb;
    @GCHH(id="zing pause upper limit", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_upper_limit_pause_mb;
    @GCHH(id="zing pause reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_reserved_pause_mb;
    @GCHH(id="zing pause initial reserved", units=LogUnits.MEGABYTES)
    public int system_zing_memory_launch_initial_reserved_pause_mb;
    @GCHH(id="process zing maximum", units=LogUnits.MEGABYTES)
    public int process_zing_memory_max_mb;
    @GCHH(id="process zing reserved (-xmx)", units=LogUnits.MEGABYTES)
    public Integer java_heap_Xmx_mb;
    @GCHH(id="process zing initial  (-xms)", units=LogUnits.MEGABYTES)
    public Integer java_heap_Xms_mb;
    @GCHH(id="java system max", units=LogUnits.MEGABYTES)
    public int javaSystemMax_mb;
    @GCHH(id="code cache location")
    public C4_FieldTypes.CacheLocation code_cache_location;
    @GCHH(id="code cache min", units=LogUnits.MEGABYTES)
    public Integer code_cache_initial_size_mb;
    @GCHH(id="code cache max", units=LogUnits.MEGABYTES)
    public Integer code_cache_size_limit_mb;
    @GCHH(id="code cache mlocked")
    public Boolean code_cache_is_mlocked;
    @GCHH(id="monitor cache location")
    public C4_FieldTypes.CacheLocation monitor_cache_location;
    @GCHH(id="monitor cache min", units=LogUnits.MEGABYTES)
    public Integer monitor_cache_initial_size_mb;
    @GCHH(id="monitor cache max", units=LogUnits.MEGABYTES)
    public Integer monitor_cache_size_limit_mb;
    @GCHH(id="monitor cache mlocked")
    public Boolean monitor_cache_is_mlocked;
    @GCHH(id="use transparent huge pages for java heap")
    public Boolean thp_for_java_heap_enabled;
    @GCHH(id="use explicit huge pages for java heap")
    public Boolean is_static_hp_for_java_heap_enabled;
    @GCHH(id="compiler tier 1")
    public String tier1_compiler;
    @GCHH(id="compiler tier 2")
    public String tier2_compiler;
    @GCHH(id="garbage collection type")
    public String garbage_collection_type;
    @GCHH(id="genpauseless phase encoding")
    public String phase_bits_encoding;
    @GCHH(id="mode")
    public String encoding_mode;
    @GCHH(id="use address tag bits")
    public Boolean is_tbi_mode;
    @GCHH(id="gen_vlim:new generation", units=LogUnits.MEGABYTES)
    public int new_gen_virtual_use_limit;
    @GCHH(id="gen_vlim:old/perm generations", units=LogUnits.MEGABYTES)
    public int old_and_perm_gen_virtual_use_limit;
    @GCHH(id="gen_plim:new generation", units=LogUnits.MEGABYTES)
    public int new_gen_physical_use_soft_limit;
    @GCHH(id="gen_plim:old/perm generations", units=LogUnits.MEGABYTES)
    public int old_and_perm_gen_physical_use_soft_limit;
    @GCHH(id="allow best effort elasticity")
    public boolean allow_best_effort_elasticity;
    @GCHH(id="process zing best effort maximum", units=LogUnits.MEGABYTES)
    public int process_zing_memory_max_best_effort_mb;
    @GCHH(id="jvm arguments")
    public String jvm_arguments;
    @GCHH(id="jvm flags")
    public String jvm_flags;
    @GCHH(id="java command")
    public String jvm_command;
    @GCHH(id="use zst")
    public Boolean use_zmm;
    @GCHH(id="dynamic gc thread count scheme")
    public String gc_thread_count_scheme;
    @GCHH(id="new gc threads")
    public Integer newGCThreads;
    @GCHH(id="old gc threads")
    public Integer oldGCThreads;
    @GCHH(id="max new gc threads")
    public Integer maxNewGCThreads;
    @GCHH(id="max old gc threads")
    public Integer maxOldGCThreads;
    @GCHH(id="page zeroing threads")
    public Integer pageZeroingThreads;
    @GCHH(id="heap commit threads")
    public Integer heapCommitThreads;
    @GCHH(id="hugepagesize", units=LogUnits.KILOBYTES)
    public Integer hugepagesize_kb;
    public AbsoluteTimestamp jvm_start_time;
    public ZoneId timeZoneId;
    public Map<String, LogLineInfo> sys_data = new HashMap<String, LogLineInfo>();
    public double active_processor_count;

    public static final class Parser
    implements C4_LogLineParser {
        private static final Map<String, Integer> keyToIdx = new HashMap<String, Integer>();
        private static final FieldSetterSupport.FieldSetter[] fieldSetters;
        private static final Field[] fields;
        private static final Map<String, String> idAltMap;
        private static final Map<String, String> sectionKeyMap;
        private C4_LogHeader header;
        private String vmStartTime;
        private String previousSectionKey;
        private String sectionPrefix;

        @Override
        public Collection<String> getPrefixes() {
            return Arrays.asList("GCHH", "GCHS");
        }

        @Override
        public C4_LogLineParser.DataLineParseResult parseDataLine(C4_ParserState state, C4_LogParser.DataLine line) throws ParserException {
            Integer fldIdx;
            boolean hasOffset;
            CharSequence value;
            String[] split;
            int idx = line.data.indexOf(": ");
            if (idx < 0) {
                return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
            }
            String key_value = line.data.substring(idx + 2);
            if ("GCHS".equals(line.prefix) && (split = key_value.split(":", 2)).length == 2) {
                String key = split[0].trim();
                value = split[1].trim();
                if (key.startsWith("/")) {
                    this.header.sys_data.put(key, new LogLineInfo(state.getCurrentLineNumber(), (String)value));
                }
            }
            if ((idx = key_value.indexOf(58)) < 0) {
                return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
            }
            Object key = key_value.substring(0, idx).trim().toLowerCase();
            if (idAltMap.containsKey(key)) {
                key = idAltMap.get(key);
            }
            boolean bl = hasOffset = key_value.charAt(0) == ' ';
            if (hasOffset) {
                if (this.sectionPrefix == null) {
                    this.sectionPrefix = sectionKeyMap.get(this.previousSectionKey);
                }
            } else {
                this.previousSectionKey = key;
                this.sectionPrefix = null;
            }
            value = TextUtils.trim(key_value.subSequence(idx + 1, key_value.length()));
            if (this.sectionPrefix != null) {
                key = this.sectionPrefix + ":" + (String)key;
            }
            if ("start time".equals(key)) {
                LogTimeModel logTimeModel = state.getLogTimeModel();
                this.vmStartTime = value.toString();
                try {
                    this.header.jvm_start_time = AbsoluteTimestamp.parse(this.vmStartTime);
                    this.header.timeZoneId = CommonUtils.guessTimeZone(this.header.jvm_start_time.toEpochTime(), this.vmStartTime);
                    logTimeModel.processAbsoluteTimestamp(this.header.jvm_start_time);
                    logTimeModel.setTimeZoneId(this.header.timeZoneId);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
            }
            if ("start time ms".equals(key)) {
                LogTimeModel logTimeModel = state.getLogTimeModel();
                long ms = Long.parseLong(value.toString());
                this.header.jvm_start_time = AbsoluteTimestamp.of((double)ms, TimeUnit.MILLISECONDS);
                this.header.timeZoneId = CommonUtils.guessTimeZone(ms, this.vmStartTime);
                logTimeModel.setAbsoluteTimestampBase(this.header.jvm_start_time);
                logTimeModel.setTimeZoneId(this.header.timeZoneId);
                return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
            }
            if (this.header.cg_active_processor_count_precise == null) {
                if ("active processor count(precise)".equals(key)) {
                    this.header.active_processor_count = Double.parseDouble(value.toString());
                } else if ("cpu period, us".equals(key)) {
                    double cpu_period = Double.parseDouble(value.toString());
                    double cpu_quota = this.header.cg_cpu_quota_us;
                    if (cpu_period > 0.0 && cpu_quota > 0.0) {
                        this.header.active_processor_count = cpu_quota / cpu_period;
                    }
                } else if ("active processor count".equals(key)) {
                    this.header.active_processor_count = Double.parseDouble(value.toString());
                }
            }
            if ((fldIdx = keyToIdx.get(key)) != null) {
                if ("hugepagesize".equals(key)) {
                    String v = value.toString();
                    value = v.substring(0, v.lastIndexOf(32)).trim();
                }
                try {
                    fieldSetters[fldIdx].setField(this.header, fields[fldIdx], value, null);
                }
                catch (IllegalArgumentException ex) {
                    throw new ParserException(state.getCurrentLineNumber(), state.getCurrentLine(), (Exception)ex);
                }
            }
            return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
        }

        @Override
        public void init(Lookup lookup) {
            this.header = lookup.lookup(C4_LogHeader.class);
        }

        static {
            idAltMap = new HashMap<String, String>();
            sectionKeyMap = new HashMap<String, String>();
            idAltMap.put("use zmm", "use zst");
            idAltMap.put("zing system max", "java system max");
            sectionKeyMap.put("genpauseless gc physical use soft limits (mb)", "gen_plim");
            sectionKeyMap.put("genpauseless gc virtual use limits (mb)", "gen_vlim");
            ArrayList<FieldSetterSupport.FieldSetter> setters = new ArrayList<FieldSetterSupport.FieldSetter>();
            ArrayList<Field> flds = new ArrayList<Field>();
            int idx = 0;
            for (Field f : C4_LogHeader.class.getDeclaredFields()) {
                GCHH annotation = f.getAnnotation(GCHH.class);
                if (annotation == null) continue;
                Class<?> type = f.getType();
                FieldSetterSupport.FieldSetter setter = FieldSetterSupport.getSetterFor(type);
                if (setter == null) {
                    throw new InternalError("Unhandled type " + type + " of a field " + f.getName());
                }
                keyToIdx.put(annotation.id(), idx);
                setters.add(setter);
                flds.add(f);
                ++idx;
            }
            fieldSetters = setters.toArray(new FieldSetterSupport.FieldSetter[0]);
            fields = flds.toArray(new Field[0]);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface GCHH {
        public String id();

        public LogUnits units() default LogUnits.UNSPECIFIED;
    }
}

