/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DoubleHeaderDataParser;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.records.CompstatsRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="CNCCOMPSTATSH", data_marker="CNCCOMPSTATS")
@C4_FieldsDescription(file="c4/CNCCompstatsRecord")
public final class CNCCompstatsRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="CompileCounts#CompilesStarted", defaultUnits=LogUnits.METHODS)
    public long compilesStarted;
    @C4_GCLogRecordField(header="CompileCounts#CompilesInstalled", defaultUnits=LogUnits.METHODS)
    public long compilesInstalled;
    @C4_GCLogRecordField(header="CompileCounts#CompilesEvicted", defaultUnits=LogUnits.METHODS)
    public long compilesEvicted;
    @C4_GCLogRecordField(header="CompileCounts#CurrentStarted", defaultUnits=LogUnits.METHODS)
    public long inFlightCompilations;
    @C4_GCLogRecordField(header="CompileCounts#CurrentStartedRemotely", defaultUnits=LogUnits.METHODS)
    public long currentCompilesStartedRemotely;
    @C4_GCLogRecordField(header="FailureCounts#ValidationFailed", defaultUnits=LogUnits.METHODS)
    public long validationFailed;
    @C4_GCLogRecordField(header="FailureCounts#InterruptedCompiles", defaultUnits=LogUnits.METHODS)
    public long interruptedCompiles;
    @C4_GCLogRecordField(header="FailureCounts#CompileRequestsNotSent", defaultUnits=LogUnits.METHODS)
    public long compileRequestsNotSent;
    @C4_GCLogRecordField(header="FailureCounts#ServerAborted", defaultUnits=LogUnits.METHODS)
    public long serverAborted;
    @C4_GCLogRecordField(header="CachedCounts#NotCached", defaultUnits=LogUnits.METHODS)
    public long notCached;
    @C4_GCLogRecordField(header="CachedCounts#IdealMatch", defaultUnits=LogUnits.METHODS)
    public long idealMatch;
    @C4_GCLogRecordField(header="CachedCounts#NonIdealMatch", defaultUnits=LogUnits.METHODS)
    public long nonIdealMatch;
    @C4_GCLogRecordField(header="CachedCounts#ExtraUnknown", defaultUnits=LogUnits.METHODS)
    public long extraUnknown;
    @C4_GCLogRecordField(header="TotalTimes ms#ActualCPUTime", defaultUnits=LogUnits.MILLISECONDS)
    public long actualCPUTime;
    @C4_GCLogRecordField(header="TotalTimes ms#WallClockTime", defaultUnits=LogUnits.MILLISECONDS)
    public long wallClockTime;
    @C4_GCLogRecordField(header="TotalTimes ms#WaitInQueueTime", defaultUnits=LogUnits.MILLISECONDS)
    public long waitInQueueTime;
    @C4_GCLogRecordField(header="WaitTimes Histogram#0-9", defaultUnits=LogUnits.METHODS)
    public long waitTimes_10;
    @C4_GCLogRecordField(header="WaitTimes Histogram#10-99", defaultUnits=LogUnits.METHODS)
    public long waitTimes_100;
    @C4_GCLogRecordField(header="WaitTimes Histogram#100-999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_1000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#1000-9999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_10000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#10000-99999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_100000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#100000-999999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_1000000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#1000000-INF", defaultUnits=LogUnits.METHODS)
    public long waitTimes_10000000;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#0-9", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_10;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#10-99", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_100;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#100-999", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_1000;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#1000-9999", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_10000;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#10000-99999", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_100000;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#100000-999999", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_1000000;
    @C4_GCLogRecordField(header="ActualCPUTimes Histogram#1000000-INF", defaultUnits=LogUnits.METHODS)
    public long actualCPUTimes_10000000;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#0-9", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_10;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#10-99", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_100;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#100-999", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_1000;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#1000-9999", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_10000;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#10000-99999", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_100000;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#100000-999999", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_1000000;
    @C4_GCLogRecordField(header="CachedCPUTimes Histogram#1000000-INF", defaultUnits=LogUnits.METHODS)
    public long cachedCPUTimes_10000000;
    @C4_GCLogRecordField(header="WallTimes Histogram#0-9", defaultUnits=LogUnits.METHODS)
    public long wallTimes_10;
    @C4_GCLogRecordField(header="WallTimes Histogram#10-99", defaultUnits=LogUnits.METHODS)
    public long wallTimes_100;
    @C4_GCLogRecordField(header="WallTimes Histogram#100-999", defaultUnits=LogUnits.METHODS)
    public long wallTimes_1000;
    @C4_GCLogRecordField(header="WallTimes Histogram#1000-9999", defaultUnits=LogUnits.METHODS)
    public long wallTimes_10000;
    @C4_GCLogRecordField(header="WallTimes Histogram#10000-99999", defaultUnits=LogUnits.METHODS)
    public long wallTimes_100000;
    @C4_GCLogRecordField(header="WallTimes Histogram#100000-999999", defaultUnits=LogUnits.METHODS)
    public long wallTimes_1000000;
    @C4_GCLogRecordField(header="WallTimes Histogram#1000000-INF", defaultUnits=LogUnits.METHODS)
    public long wallTimes_10000000;
    @C4_GCLogRecordField(header="end#end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;
    @LogRecordCalculatedField(deps={"validationFailed", "serverAborted"}, defaultUnits=LogUnits.METHODS)
    public long failedRemoteCompiles;
    @LogRecordCalculatedField(deps={"idealMatch", "nonIdealMatch"}, defaultUnits=LogUnits.METHODS)
    public long cachedMethodCompiles;
    @LogRecordCalculatedField(deps={"compilesInstalled", "validationFailed"}, defaultUnits=LogUnits.METHODS)
    public long codeDeliveries;
    @LogRecordCalculatedField(deps={"compilesStarted"}, defaultUnits=LogUnits.METHODS)
    public long totalMethodCompiles;
    @LogRecordCalculatedField(deps={"compilesEvicted"}, defaultUnits=LogUnits.METHODS)
    public long totalMethodsEvicted;
    @LogRecordCalculatedField(deps={"validationFailed", "serverAborted"}, defaultUnits=LogUnits.METHODS)
    public long totalFailedCompiles;
    @LogRecordCalculatedField(deps={"codeDeliveries", "validationFailed"}, defaultUnits=LogUnits.METHODS)
    public long usedCompiles;
    @LogRecordCalculatedField(deps={"compilesStarted", "compilesInstalled", "validationFailed", "serverAborted", "interruptedCompiles"}, defaultUnits=LogUnits.METHODS)
    public long inFlightCompilationsDerived;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_DoubleHeaderDataParser<CNCCompstatsRecord> {
        private static final String[] firstLineFixupMatrix = new String[]{" : CompileCounts                                        : FailureCounts                    : ServerAbortedDetails                                                              : CachedCounts                                    : TotalTimes ms                               : WaitTimes Histogram                                               : ActualCPUTimes Histogram                                          : CachedCPUTimes Histogram                                          : WallTimes Histogram                                               : end", " : CompilesStarted  CompilesInstalled  CompilesEvicted  : ValidationFailed  InterruptedCompiles  CompileRequestsNotSent  ServerAborted  : ErrorUndefined  ServerError  ServerBackpressure  ServerCompilerError  BadRequest  : NotCached IdealMatch NonIdealMatch ExtraUnknown : ActualCPUTime WallClockTime WaitInQueueTime : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF : end(s)", " : CompileCounts                                        : FailureCounts                                                                 : ServerAbortedDetails                                                              : CachedCounts                                    : TotalTimes ms                               : WaitTimes Histogram                                               : ActualCPUTimes Histogram                                          : CachedCPUTimes Histogram                                          : WallTimes Histogram                                               : end"};
        private C4_ParserState state;

        public Parser() {
            super(CNCCompstatsRecord.class);
        }

        @Override
        protected String[] getFirstLineFixupMatrix() {
            return firstLineFixupMatrix;
        }

        @Override
        protected void computeCalculatedFields(CNCCompstatsRecord record) throws ParserException {
            record.failedRemoteCompiles = record.validationFailed + record.serverAborted;
            record.cachedMethodCompiles = record.idealMatch + record.nonIdealMatch;
            record.codeDeliveries = record.compilesInstalled + record.validationFailed;
            record.usedCompiles = record.codeDeliveries - record.validationFailed;
            record.inFlightCompilationsDerived = record.compilesStarted - record.codeDeliveries - record.serverAborted - record.interruptedCompiles;
            CompstatsRecord lastCompstatsRecord = Optional.ofNullable(this.state.getLastRecordOfType(CompstatsRecord.class)).orElseGet(CompstatsRecord::new);
            record.totalMethodCompiles = lastCompstatsRecord.methodCompiles + record.compilesStarted;
            record.totalMethodsEvicted = lastCompstatsRecord.methodsEvicted + record.compilesEvicted;
            record.totalFailedCompiles = lastCompstatsRecord.methodsFailedToInstall + record.failedRemoteCompiles;
        }

        @Override
        protected void init_impl(Lookup lookup) {
            this.state = lookup.lookup(C4_ParserState.class);
        }
    }
}

