/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="CPSH", data_marker="CPS")
@C4_FieldsDescription(file="c4/CheckpointRecord")
public final class CheckpointRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="lock", defaultUnits=LogUnits.MILLISECONDS)
    public double threads_lock_ms;
    @C4_GCLogRecordField(header="notify", defaultUnits=LogUnits.MILLISECONDS)
    public double notify_ms;
    @C4_GCLogRecordField(header="threads_total", defaultUnits=LogUnits.THREADS)
    public int threads_total;
    @C4_GCLogRecordField(header="threads_self", defaultUnits=LogUnits.THREADS)
    public int threads_self;
    @C4_GCLogRecordField(header="thread_closure", defaultUnits=LogUnits.MILLISECONDS)
    public double thread_closure_dur;
    @C4_GCLogRecordField(header="total_closure", defaultUnits=LogUnits.MILLISECONDS)
    public double total_closure_dur;
    @C4_GCLogRecordField(header="spin_cnt", defaultUnits=LogUnits.COUNT)
    public int spin_cnt;
    @C4_GCLogRecordField(header="promo_stall_threads", defaultUnits=LogUnits.COUNT)
    public int promo_stall_threads;
    @C4_GCLogRecordField(header="promo_start_iteration", defaultUnits=LogUnits.COUNT)
    public int promo_start_iteration;
    @C4_GCLogRecordField(header="promo_load1")
    public double promo_load1;
    @C4_GCLogRecordField(header="promo_load5")
    public double promo_load5;
    @C4_GCLogRecordField(header="promo_load15")
    public double promo_load15;
    @C4_GCLogRecordField(header="promo_notify", defaultUnits=LogUnits.MILLISECONDS)
    public double promo_notify_ms;
    @C4_GCLogRecordField(header="promo_time", defaultUnits=LogUnits.MILLISECONDS)
    public double promo_time_ms;
    @C4_GCLogRecordField(header="promo_wakeup", defaultUnits=LogUnits.MILLISECONDS)
    public double promo_wakeup_ms;
    @C4_GCLogRecordField(header="extended_cnt", defaultUnits=LogUnits.COUNT)
    public int extended_cnt;
    @C4_GCLogRecordField(header="extended_reason")
    public String extended_reason;
    @C4_GCLogRecordField(header="boosted_after", defaultUnits=LogUnits.MILLISECONDS)
    public double boosted_after_ms;
    @C4_GCLogRecordField(header="checkpoint_time", defaultUnits=LogUnits.MILLISECONDS)
    public double checkpoint_time_ms;
    @C4_GCLogRecordField(header="total_time", defaultUnits=LogUnits.MILLISECONDS)
    public double total_time_ms;
    @C4_GCLogRecordField(header="op_name")
    public String vm_op_name;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double checkpoint_end_time;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MILLISECONDS, deps={"threads_total", "thread_closure_dur", "threads_self"})
    public double avg_thread_closure_dur;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MILLISECONDS, deps={"total_closure_dur", "thread_closure_dur", "threads_self"})
    public double avg_self_closure_dur;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MILLISECONDS, deps={"promo_notify_ms", "promo_time_ms", "promo_wakeup_ms"})
    public double promo_pause_time_ms;

    public boolean isPromoted() {
        return this.promo_stall_threads > 0;
    }

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.checkpoint_end_time, TimeUnit.SECONDS);
    }

    public boolean isUnknownOp() {
        switch (this.vm_op_name) {
            case "DeflationThreadClosure": 
            case "GPGC_FixupJavaThreadsClosure": 
            case "GPGC_NMTClearClosure": 
            case "GPGC_NMTFlushClosure": 
            case "GPGC_NewGC_CleanDirtyThreadsClosure": 
            case "GPGC_NewGC_FixupJavaThreadsClosure": 
            case "GPGC_OldGC_FixupJavaThreadsClosure": 
            case "GPGC_SaveObjectInitStatsThreadClosure": 
            case "GPGC_UnshatteredPageTrapCountClosure": 
            case "NopThreadClosure": {
                return false;
            }
        }
        return true;
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<CheckpointRecord> {
        public Parser() {
            super(CheckpointRecord.class);
        }

        @Override
        protected void computeCalculatedFields(CheckpointRecord record) {
            int threads_thread = record.threads_total - record.threads_self;
            record.avg_thread_closure_dur = threads_thread == 0 ? 0.0 : record.thread_closure_dur / (double)threads_thread;
            double self_closure_dur = record.total_closure_dur - record.thread_closure_dur;
            record.avg_self_closure_dur = record.threads_self == 0 ? 0.0 : self_closure_dur / (double)record.threads_self;
            record.promo_pause_time_ms = record.promo_notify_ms + record.promo_time_ms + record.promo_wakeup_ms;
        }
    }
}

