/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_DoubleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="GCREFH", data_marker="GCREF")
@C4_FieldsDescription(file="c4/GCRecord")
public final class GCRefRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="type")
    public String type;
    @C4_GCLogRecordField(header="weak#tot_get", defaultUnits=LogUnits.COUNT)
    public long weakRefTotalGets;
    @C4_GCLogRecordField(header="weak#max_get", defaultUnits=LogUnits.COUNT)
    public long weakRefMaxGets;
    @C4_GCLogRecordField(header="weak#tot_str", defaultUnits=LogUnits.COUNT)
    public long weakRefTotalStrengthenedRefs;
    @C4_GCLogRecordField(header="weak#max_str", defaultUnits=LogUnits.COUNT)
    public long weakRefMaxStrengthenedRefs;
    @C4_GCLogRecordField(header="end#end(s)", defaultUnits=LogUnits.MICROSECONDS)
    public double end_s;

    public boolean isNew() {
        return !this.isOld();
    }

    public boolean isOld() {
        return "Old".equals(this.type);
    }

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_DoubleHeaderDataParser<GCRefRecord> {
        public Parser() {
            super(GCRefRecord.class);
        }
    }
}

