/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="HMSVH", data_marker="HMSV")
@C4_FieldsDescription(file="c4/HeapManagementVStatsRecord")
public class HeapManagementVStatsRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="maps", defaultUnits=LogUnits.COUNT)
    public int maps;
    @C4_GCLogRecordField(header="mapStomps", defaultUnits=LogUnits.COUNT)
    public int map_stomps;
    @C4_GCLogRecordField(header="mapReuses", defaultUnits=LogUnits.COUNT)
    public int map_reuses;
    @C4_GCLogRecordField(header="cacheHits", defaultUnits=LogUnits.COUNT)
    public int cache_hits;
    @C4_GCLogRecordField(header="cacheMisses", defaultUnits=LogUnits.COUNT)
    public int cache_misses;
    @C4_GCLogRecordField(header="cachePartFlushes", defaultUnits=LogUnits.COUNT)
    public int cache_part_flushes;
    @C4_GCLogRecordField(header="cacheFullFlushes", defaultUnits=LogUnits.COUNT)
    public int cache_full_flushes;
    @C4_GCLogRecordField(header="watermark", defaultUnits=LogUnits.MEGABYTES)
    public int watermark;
    @C4_GCLogRecordField(header="cached", defaultUnits=LogUnits.MEGABYTES)
    public int cached;
    @C4_GCLogRecordField(header="cachedMin", defaultUnits=LogUnits.MEGABYTES)
    public int cachedMin;
    @C4_GCLogRecordField(header="cachedMax", defaultUnits=LogUnits.MEGABYTES)
    public int cachedMax;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<HeapManagementVStatsRecord> {
        public Parser() {
            super(HeapManagementVStatsRecord.class);
        }

        @Override
        protected boolean parseHeaderImpl(String header) throws ParserException {
            return !header.startsWith("gen") && super.parseHeaderImpl(header);
        }
    }
}

