/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="NMTH", data_marker="NMT")
@C4_FieldsDescription(file="c4/NMTRecord")
public final class NMTRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="totalCommittedBytes", defaultUnits=LogUnits.BYTES)
    public long totalCommittedBytes;
    @C4_GCLogRecordField(header="totalMallocBytes", defaultUnits=LogUnits.BYTES)
    public long totalMallocBytes;
    @C4_GCLogRecordField(header="totalMallocCnt", defaultUnits=LogUnits.COUNT)
    public long totalMallocCnt;
    @C4_GCLogRecordField(header="totalMmapReserved", defaultUnits=LogUnits.BYTES)
    public long totalMmapReserved;
    @C4_GCLogRecordField(header="totalMmapCommitted", defaultUnits=LogUnits.BYTES)
    public long totalMmapCommitted;
    @C4_GCLogRecordField(header="JavaHeapMmapReserved", defaultUnits=LogUnits.BYTES)
    public long javaHeapMmapReserved;
    @C4_GCLogRecordField(header="JavaHeapMmapCommitted", defaultUnits=LogUnits.BYTES)
    public long javaHeapMmapCommitted;
    @C4_GCLogRecordField(header="ClassInstanceCnt", defaultUnits=LogUnits.COUNT)
    public long classInstanceCnt;
    @C4_GCLogRecordField(header="ClassArrayCnt", defaultUnits=LogUnits.COUNT)
    public long classArrayCnt;
    @C4_GCLogRecordField(header="ClassMallocBytes", defaultUnits=LogUnits.BYTES)
    public long classMallocBytes;
    @C4_GCLogRecordField(header="ClassMallocCnt", defaultUnits=LogUnits.COUNT)
    public long classMallocCnt;
    @C4_GCLogRecordField(header="ThreadCnt", defaultUnits=LogUnits.COUNT)
    public long threadCnt;
    @C4_GCLogRecordField(header="ThreadStackReserved", defaultUnits=LogUnits.BYTES)
    public long threadStackReserved;
    @C4_GCLogRecordField(header="ThreadStackCommitted", defaultUnits=LogUnits.BYTES)
    public long threadStackCommitted;
    @C4_GCLogRecordField(header="ThreadMallocBytes", defaultUnits=LogUnits.BYTES)
    public long threadMallocBytes;
    @C4_GCLogRecordField(header="ThreadMallocCnt", defaultUnits=LogUnits.COUNT)
    public long threadMallocCnt;
    @C4_GCLogRecordField(header="ThreadArenaBytes", defaultUnits=LogUnits.BYTES)
    public long threadArenaBytes;
    @C4_GCLogRecordField(header="ThreadArenaCnt", defaultUnits=LogUnits.COUNT)
    public long threadArenaCnt;
    @C4_GCLogRecordField(header="CodeMallocBytes", defaultUnits=LogUnits.BYTES)
    public long codeMallocBytes;
    @C4_GCLogRecordField(header="CodeMallocCnt", defaultUnits=LogUnits.COUNT)
    public long codeMallocCnt;
    @C4_GCLogRecordField(header="CodeMmapReserved", defaultUnits=LogUnits.BYTES)
    public long codeMmapReserved;
    @C4_GCLogRecordField(header="CodeMmapCommitted", defaultUnits=LogUnits.BYTES)
    public long codeMmapCommitted;
    @C4_GCLogRecordField(header="GCMallocBytes", defaultUnits=LogUnits.BYTES)
    public long gcMallocBytes;
    @C4_GCLogRecordField(header="GCMallocCnt", defaultUnits=LogUnits.COUNT)
    public long gcMallocCnt;
    @C4_GCLogRecordField(header="GCMmapReserved", defaultUnits=LogUnits.BYTES)
    public long gcMmapReserved;
    @C4_GCLogRecordField(header="GCMmapCommitted", defaultUnits=LogUnits.BYTES)
    public long gcMmapCommitted;
    @C4_GCLogRecordField(header="CompilerMallocBytes", defaultUnits=LogUnits.BYTES)
    public long compilerMallocBytes;
    @C4_GCLogRecordField(header="CompilerMallocCnt", defaultUnits=LogUnits.COUNT)
    public long compilerMallocCnt;
    @C4_GCLogRecordField(header="CompilerArenaBytes", defaultUnits=LogUnits.BYTES)
    public long compilerArenaBytes;
    @C4_GCLogRecordField(header="CompilerArenaCnt", defaultUnits=LogUnits.COUNT)
    public long compilerArenaCnt;
    @C4_GCLogRecordField(header="CompilerRuntimeMallocBytes", defaultUnits=LogUnits.BYTES)
    public long compilerRuntimeMallocBytes;
    @C4_GCLogRecordField(header="CompilerRuntimeMallocCnt", defaultUnits=LogUnits.COUNT)
    public long compilerRuntimeMallocCnt;
    @C4_GCLogRecordField(header="CompilerRuntimeArenaBytes", defaultUnits=LogUnits.BYTES)
    public long compilerRuntimeArenaBytes;
    @C4_GCLogRecordField(header="CompilerRuntimeArenaCnt", defaultUnits=LogUnits.COUNT)
    public long compilerRuntimeArenaCnt;
    @C4_GCLogRecordField(header="PersistentProfileMallocBytes", defaultUnits=LogUnits.BYTES)
    public long persistentProfileMallocBytes;
    @C4_GCLogRecordField(header="PersistentProfileMallocCnt", defaultUnits=LogUnits.COUNT)
    public long persistentProfileMallocCnt;
    @C4_GCLogRecordField(header="PersistentProfileArenaBytes", defaultUnits=LogUnits.BYTES)
    public long persistentProfileArenaBytes;
    @C4_GCLogRecordField(header="PersistentProfileArenaCnt", defaultUnits=LogUnits.COUNT)
    public long persistentProfileArenaCnt;
    @C4_GCLogRecordField(header="InternalMallocBytes", defaultUnits=LogUnits.BYTES)
    public long internalMallocBytes;
    @C4_GCLogRecordField(header="InternalMallocCnt", defaultUnits=LogUnits.COUNT)
    public long internalMallocCnt;
    @C4_GCLogRecordField(header="InternalMmapReserved", defaultUnits=LogUnits.BYTES)
    public long internalMmapReserved;
    @C4_GCLogRecordField(header="InternalMmapCommitted", defaultUnits=LogUnits.BYTES)
    public long internalMmapCommitted;
    @C4_GCLogRecordField(header="UnsafeMallocBytes", defaultUnits=LogUnits.BYTES)
    public long unsafeMallocBytes;
    @C4_GCLogRecordField(header="UnsafeMallocCnt", defaultUnits=LogUnits.COUNT)
    public long unsafeMallocCnt;
    @C4_GCLogRecordField(header="OtherMallocBytes", defaultUnits=LogUnits.BYTES)
    public long otherMallocBytes;
    @C4_GCLogRecordField(header="OtherMallocCnt", defaultUnits=LogUnits.COUNT)
    public long otherMallocCnt;
    @C4_GCLogRecordField(header="OtherMmapReserved", defaultUnits=LogUnits.BYTES)
    public long otherMmapReserved;
    @C4_GCLogRecordField(header="OtherMmapCommitted", defaultUnits=LogUnits.BYTES)
    public long otherMmapCommitted;
    @C4_GCLogRecordField(header="SymbolMallocBytes", defaultUnits=LogUnits.BYTES)
    public long symbolMallocBytes;
    @C4_GCLogRecordField(header="SymbolMallocCnt", defaultUnits=LogUnits.COUNT)
    public long symbolMallocCnt;
    @C4_GCLogRecordField(header="NMTMallocBytes", defaultUnits=LogUnits.BYTES)
    public long nmtMallocBytes;
    @C4_GCLogRecordField(header="NMTMallocCnt", defaultUnits=LogUnits.COUNT)
    public long nmtMallocCnt;
    @C4_GCLogRecordField(header="NMTTrackingOverhead", defaultUnits=LogUnits.BYTES)
    public long nmtTrackingOverhead;
    @C4_GCLogRecordField(header="ChunkMallocBytes", defaultUnits=LogUnits.BYTES)
    public long chunkMallocBytes;
    @C4_GCLogRecordField(header="TracingMallocBytes", defaultUnits=LogUnits.BYTES)
    public long tracingMallocBytes;
    @C4_GCLogRecordField(header="TracingMallocCnt", defaultUnits=LogUnits.COUNT)
    public long tracingMallocCnt;
    @C4_GCLogRecordField(header="LoggingMallocBytes", defaultUnits=LogUnits.BYTES)
    public long loggingMallocBytes;
    @C4_GCLogRecordField(header="LoggingMallocCnt", defaultUnits=LogUnits.COUNT)
    public long loggingMallocCnt;
    @C4_GCLogRecordField(header="ArgumentsMallocBytes", defaultUnits=LogUnits.BYTES)
    public long argumentsMallocBytes;
    @C4_GCLogRecordField(header="ArgumentsMallocCnt", defaultUnits=LogUnits.COUNT)
    public long argumentsMallocCnt;
    @C4_GCLogRecordField(header="ModuleMallocBytes", defaultUnits=LogUnits.BYTES)
    public long moduleMallocBytes;
    @C4_GCLogRecordField(header="ModuleMallocCnt", defaultUnits=LogUnits.COUNT)
    public long moduleMallocCnt;
    @C4_GCLogRecordField(header="SynchronizerMallocBytes", defaultUnits=LogUnits.BYTES)
    public long synchronizerMallocBytes;
    @C4_GCLogRecordField(header="SynchronizerMallocCnt", defaultUnits=LogUnits.COUNT)
    public long synchronizerMallocCnt;
    @C4_GCLogRecordField(header="ObjectMonitorMallocBytes", defaultUnits=LogUnits.BYTES)
    public long objectMonitorMallocBytes;
    @C4_GCLogRecordField(header="ObjectMonitorMallocCnt", defaultUnits=LogUnits.COUNT)
    public long objectMonitorMallocCnt;
    @C4_GCLogRecordField(header="StatisticsMallocBytes", defaultUnits=LogUnits.BYTES)
    public long statisticsMallocBytes;
    @C4_GCLogRecordField(header="StatisticsMallocCnt", defaultUnits=LogUnits.COUNT)
    public long statisticsMallocCnt;
    @C4_GCLogRecordField(header="ServiceabilityMallocBytes", defaultUnits=LogUnits.BYTES)
    public long serviceabilityMallocBytes;
    @C4_GCLogRecordField(header="ServiceabilityMallocCnt", defaultUnits=LogUnits.COUNT)
    public long serviceabilityMallocCnt;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;
    @LogRecordCalculatedField(defaultUnits=LogUnits.BYTES, deps={"totalMmapCommitted", "javaHeapMmapCommitted", "codeMmapCommitted"})
    public double nonJavaHeapMmapMinusCodeMmapCommitted;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<NMTRecord> {
        public Parser() {
            super(NMTRecord.class);
        }

        @Override
        protected boolean parseHeaderImpl(String header) throws ParserException {
            if (header.startsWith("mt")) {
                header = header.replaceFirst("mt", "").replaceAll(" mt", " ");
            }
            if (header.contains("CompilerRuntimeMallocCount")) {
                header = header.replace("CompilerRuntimeMallocCount", "CompilerRuntimeMallocCnt");
            }
            if (header.contains("CompilerRuntimeArenaCount")) {
                header = header.replace("CompilerRuntimeArenaCount", "CompilerRuntimeArenaCnt");
            }
            if (header.contains("PersistentProfileArenaCount")) {
                header = header.replace("PersistentProfileArenaCount", "PersistentProfileArenaCnt");
            }
            return super.parseHeaderImpl(header);
        }

        @Override
        protected void computeCalculatedFields(NMTRecord record) throws ParserException {
            record.nonJavaHeapMmapMinusCodeMmapCommitted = record.totalMmapCommitted - (record.javaHeapMmapCommitted + record.codeMmapCommitted);
        }
    }
}

