/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.metrics;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.LogLineParser;
import com.azul.log.parser.impl.metrics.Metrics_Parser;
import com.azul.log.parser.impl.metrics.Metrics_ParserState;
import com.azul.log.parser.impl.spi.annotations.GCLogLineData;
import com.azul.log.parser.impl.support.CustomParsersCompiler;
import com.azul.log.parser.spi.annotations.LogLineField;
import com.azul.log.parser.support.FieldSetterSupport;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.parser.utils.spi.FieldSetterImplementation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class Metrics_ParserSupport {
    private static final String PACKAGE = Metrics_Parser.class.getPackage().getName() + ".impl";
    private static final CustomParsersCompiler compiler = CustomParsersCompiler.create();

    private Metrics_ParserSupport() {
    }

    static <R extends Metrics_Parser.Metrics_Record> LogLineParser<R, Metrics_ParserState> generateMetricsRecordClass(String[] columns) {
        if (compiler == null) {
            return null;
        }
        compiler.reset();
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(PACKAGE).append(";");
        Stream.of(GCLogLineData.class, LogLineField.class, LogUnits.class, Metrics_Parser.Metrics_LogLineParser.class, Metrics_Parser.Metrics_Record.class).forEach(c -> sb.append("import ").append(c.getCanonicalName()).append(";"));
        String recordClassName = "Metrics_RecordImpl";
        sb.append("@").append(GCLogLineData.class.getSimpleName()).append("(parserClass = ").append(Metrics_Parser.Metrics_LogLineParser.class.getSimpleName()).append(".class)");
        sb.append("public final class ").append(recordClassName).append(" extends ").append(Metrics_Parser.Metrics_Record.class.getSimpleName()).append(" {");
        for (int i = 1; i < columns.length; ++i) {
            String column = columns[i].replaceAll("[^A-Za-z0-9]", "");
            Class<?> type = Metrics_ParserSupport.guessType(column);
            sb.append("@").append(LogLineField.class.getSimpleName());
            sb.append("(");
            sb.append("name = \"").append(column).append("\"");
            if (DurationInSec.class.equals(type)) {
                sb.append(", defaultUnits = LogUnits.SECONDS");
            } else {
                sb.append(", defaultUnits = ").append("LogUnits.").append(Metrics_ParserSupport.guessUnits(column).name());
            }
            sb.append(") ");
            sb.append("public ").append(type.getCanonicalName()).append(" ").append(TextUtils.toValidJavaIdentifier("m_", column)).append(";");
        }
        sb.append("public static final class Parser extends ").append(Metrics_Parser.Metrics_LogLineParser.class.getSimpleName()).append("<").append(recordClassName).append("> { public Parser() { super(").append(recordClassName).append(".class); }}}");
        String fullName = PACKAGE + "." + recordClassName;
        compiler.compile(fullName, sb.toString());
        return Metrics_ParserSupport.instantiateGeneratedParser(fullName);
    }

    private static Class<?> guessType(String column) {
        switch (column) {
            case "ResponseTime": {
                return DurationInSec.class;
            }
        }
        return Double.TYPE;
    }

    private static LogUnits guessUnits(String column) {
        int idx;
        if (column.endsWith(")") && (idx = column.lastIndexOf(40)) > 0) {
            switch (column.substring(idx + 1, column.length() - 1).toUpperCase()) {
                case "%": {
                    return LogUnits.PERCENT;
                }
                case "COUNT": {
                    return LogUnits.COUNT;
                }
                case "CORES": {
                    return LogUnits.CORES;
                }
            }
        }
        return LogUnits.UNSPECIFIED;
    }

    private static <R extends Metrics_Parser.Metrics_Record> LogLineParser<R, Metrics_ParserState> instantiateGeneratedParser(String fullName) {
        try {
            compiler.loadClass(fullName);
            Class parserClass = compiler.loadClass(fullName + "$Parser");
            Constructor constructor = parserClass.getDeclaredConstructor(new Class[0]);
            return (LogLineParser)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            Logger.getLogger(Metrics_ParserSupport.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static final class DurationInSecSetter
    implements FieldSetterImplementation {
        public static DurationInSec fromString(String info, LogUnits defaultUnits) throws ParserException {
            return new DurationInSec(TextUtils.parseDuration(info, LogUnits.SECONDS).getNanos());
        }

        @Override
        public Class<?> getType() {
            return DurationInSec.class;
        }

        @Override
        public FieldSetterSupport.FieldSetter getSetter() {
            return (inst, field, value, defaultUnits) -> {
                try {
                    LogFieldTypes.Duration d = TextUtils.parseDuration(value.toString(), LogUnits.SECONDS);
                    if (d != null) {
                        field.set(inst, new DurationInSec(d.getNanos()));
                        return true;
                    }
                }
                catch (ParserException | IllegalAccessException ex) {
                    Logger.getLogger(DurationInSecSetter.class.getName()).log(Level.SEVERE, null, ex);
                }
                return false;
            };
        }
    }

    public static final class DurationInSec
    extends LogFieldTypes.Duration {
        public DurationInSec(long nanoseconds) {
            super(nanoseconds);
        }

        @Override
        public Double getDoubleValue(LogUnits targetUnits) {
            return super.getDoubleValue(LogUnits.SECONDS);
        }
    }
}

