/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.nmt;

import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.nmt.NMT_LogLineParser;
import com.azul.log.parser.impl.nmt.annotations.NMT_LogRecordField;
import com.azul.log.parser.impl.nmt.records.NMT_LogRecord;
import com.azul.log.parser.support.LogDataFieldsAccessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class NMT_LogLineParserImpl<T extends NMT_LogRecord>
implements NMT_LogLineParser {
    private final Class<T> klass;
    private final List<Field> fields;
    private final LogDataFieldsAccessor accessor = LogDataFieldsAccessor.getInstance();

    NMT_LogLineParserImpl(Class<T> klass) {
        this.klass = klass;
        this.fields = this.init_fields();
    }

    private List<Field> init_fields() {
        ArrayList fieldList = new ArrayList();
        Arrays.stream(this.klass.getFields()).forEach(field -> {
            if (field.isAnnotationPresent(NMT_LogRecordField.class)) {
                fieldList.add(field);
            }
        });
        return Collections.unmodifiableList(fieldList);
    }

    public T parseLine(List<String> tokens) throws ParserException {
        int i;
        NMT_LogRecord record;
        if (tokens.size() > this.fields.size()) {
            throw new ParserException("Tokens number (" + tokens.size() + ") is bigger than expected tokens number (" + this.fields.size() + ").");
        }
        try {
            record = (NMT_LogRecord)this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (i = 0; i < tokens.size(); ++i) {
                this.accessor.setFieldValueFromString(record, this.fields.get(i), tokens.get(i));
            }
        }
        catch (Exception ex) {
            throw new ParserException("Cannot assign value '" + tokens.get(i) + "' to field " + this.fields.get(i) + ". " + ex.getMessage());
        }
        return (T)record;
    }
}

