/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.support;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public final class CustomParsersCompiler
implements Closeable {
    private final FileManagerImpl fileManager;
    private final JavaCompiler compiler;
    private ClassLoaderImpl classLoader;

    private CustomParsersCompiler(JavaCompiler jc) {
        this.compiler = jc;
        this.fileManager = new FileManagerImpl(this.compiler.getStandardFileManager(null, null, null));
    }

    public static CustomParsersCompiler create() {
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        return jc == null ? null : new CustomParsersCompiler(jc);
    }

    @Override
    public void close() throws IOException {
        this.fileManager.close();
    }

    public <T> Class<? extends T> loadClass(String fullName) throws ClassNotFoundException {
        return this.classLoader.loadClass(fullName, this.fileManager);
    }

    public void compile(String classFullName, String code) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StringWriter warnings = new StringWriter();
        JavaCompiler.CompilationTask task = this.compiler.getTask(warnings, this.fileManager, diagnostics, Arrays.asList("-source", "1.8"), null, Collections.singletonList(new JavaInputFile(classFullName, code)));
        if (!task.call().booleanValue()) {
            System.err.println("Error while compiling generated class:");
            diagnostics.getDiagnostics().forEach(System.err::println);
            System.err.println(warnings);
        }
    }

    public void reset() {
        this.classLoader = new ClassLoaderImpl();
        this.fileManager.files.clear();
    }

    private static final class ClassOutputFile
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public ClassOutputFile(String name) {
            super(URI.create("mem:///" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() {
            return this.outputStream;
        }
    }

    private static final class JavaInputFile
    extends SimpleJavaFileObject {
        private final String code;

        public JavaInputFile(String fullName, String code) {
            super(URI.create("string:///" + fullName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    private static final class ClassLoaderImpl
    extends ClassLoader {
        private ClassLoaderImpl() {
        }

        public <T> Class<T> loadClass(String fullName, FileManagerImpl fileManager) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(fullName);
            if (clazz == null) {
                ClassOutputFile klass = fileManager.getClass(fullName);
                byte[] bytes = klass.outputStream.toByteArray();
                clazz = this.defineClass(fullName, bytes, 0, bytes.length);
            }
            return clazz;
        }
    }

    private static final class FileManagerImpl
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final Map<String, ClassOutputFile> files = new HashMap<String, ClassOutputFile>();

        public FileManagerImpl(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            ClassOutputFile klass = new ClassOutputFile(className);
            this.files.put(className, klass);
            return klass;
        }

        private ClassOutputFile getClass(String className) throws ClassNotFoundException {
            if (this.files.containsKey(className)) {
                return this.files.get(className);
            }
            throw new ClassNotFoundException();
        }
    }
}

