/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.support;

import com.azul.log.parser.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class SummarySupport {
    private final List<Function<CharSequence, Boolean>> extractors = new ArrayList<Function<CharSequence, Boolean>>();
    private Consumer<CharSequence> factsExtractor = l -> {
        if (!this.apply((CharSequence)l) || stopCondition.test((CharSequence)l)) {
            this.factsExtractor = line -> {};
        }
    };
    private int current = 0;

    public SummarySupport(Predicate<CharSequence> stopCondition) {
    }

    public SummarySupport addPrefixedExtractorC(CharSequence prefix, Consumer<String> consumer) {
        String str = prefix.toString();
        int len = str.length();
        this.addExtractor(l -> {
            int idx = TextUtils.indexOfIgnoreCase(l, str, 0);
            if (idx >= 0) {
                consumer.accept(l.toString().substring(idx + len).trim());
                return true;
            }
            return false;
        });
        return this;
    }

    public SummarySupport addPrefixedExtractorF(CharSequence prefix, Function<String, Boolean> consumer) {
        String str = prefix.toString();
        int len = str.length();
        this.addExtractor(l -> {
            int idx = TextUtils.indexOf(l, str, 0);
            if (idx > 0) {
                return (Boolean)consumer.apply(l.toString().substring(idx + len).trim());
            }
            return false;
        });
        return this;
    }

    public SummarySupport addExtractor(Function<CharSequence, Boolean> extractor) {
        this.extractors.add(extractor);
        return this;
    }

    public void process(CharSequence line) {
        this.factsExtractor.accept(line);
    }

    private boolean apply(CharSequence line) {
        int size = this.extractors.size();
        for (int i = 0; i < size; ++i) {
            int idx = (this.current + i) % size;
            if (!this.extractors.get(idx).apply(line).booleanValue()) continue;
            this.extractors.remove(idx);
            this.current = idx;
            break;
        }
        return !this.extractors.isEmpty();
    }
}

