/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.model.spi.LogLineWithTimeProvider;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.spi.LogParserImplBase;
import com.azul.log.parser.spi.ParserState;
import com.azul.log.parser.spi.UserInteractionHandler;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public abstract class LogParserImpl<T extends ParserState>
extends LogParserImplBase<T> {
    protected LogParserImpl(LogModel model, T state) {
        super(model, state);
        this.ic.add(((ParserState)state).getLogTimeModel());
        this.ic.add(new LogLineWithTimeProviderImpl());
    }

    public final void processLine(int lineNumber, CharSequence line) throws ParserException {
        LogLineWithTime logLineWithTime = this.parseLogLineImpl(line);
        if (logLineWithTime == null) {
            logLineWithTime = new LogLineWithTime(line);
        }
        this.processLine(lineNumber, logLineWithTime);
    }

    public final void processLine(int lineNumber, LogLineWithTime logLineWithTime) throws ParserException {
        this.state.setCurrentLogLine(lineNumber, logLineWithTime);
        this.model.recordLogLineStartTimes(lineNumber, logLineWithTime);
        List<LogRecord> records = this.getLogRecordsImpl(logLineWithTime.getData());
        if (records != null) {
            RelativeTimestamp ts = this.state.getCurrentLineRelativeTimestamp();
            records.forEach(r -> {
                this.accessor.setRecordLineNumberAndRelativeLogTimestamp((LogRecord)r, lineNumber, ts);
                this.accessor.addRecordToLogRecordsMap(this.model.getRecordsMap(), (LogRecord)r);
                this.state.setLastRecord(r);
            });
        }
    }

    protected List<Path> initFiles(Path path, UserInteractionHandler ui) {
        return Collections.singletonList(path);
    }

    public void teardown() {
    }

    protected abstract LogLineWithTime parseLogLineImpl(CharSequence var1) throws ParserException;

    protected abstract List<? extends LogRecord> getLogRecordsImpl(String var1) throws ParserException;

    private class LogLineWithTimeProviderImpl
    implements LogLineWithTimeProvider {
        private LogLineWithTimeProviderImpl() {
        }

        @Override
        public LogLineWithTime parse(CharSequence line) throws ParserException {
            return LogParserImpl.this.parseLogLineImpl(line);
        }
    }
}

