/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.UserInteractionHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.util.Lookup;

public abstract class ParserFactory<T extends LogParserImpl<?>> {
    private final List<String[]> sets;
    private final Confidence confidence;
    private static final int MAX_FILE_LINES = 1000;

    public ParserFactory(Confidence confidence, String[] ... sets) {
        this.sets = new ArrayList(Arrays.asList(sets));
        this.confidence = confidence;
    }

    public static List<? extends ParserFactory<?>> getParserFactoriesFor(Path log) {
        List list;
        block8: {
            Set allExpectedLogLineMatches = Lookup.getDefault().lookupAll(ParserFactory.class).stream().map(x -> x.getSets()).flatMap(Collection::stream).flatMap(Arrays::stream).collect(Collectors.toSet());
            Stream<String> linesStream = Files.lines(log);
            try {
                List matchedLines = linesStream.limit(1000L).filter(line -> allExpectedLogLineMatches.stream().anyMatch(line::contains)).collect(Collectors.toList());
                Collection<ParserFactory> factories = Lookup.getDefault().lookupAll(ParserFactory.class);
                list = factories.stream().filter(f -> f.matches(matchedLines)).collect(Collectors.toList());
                if (linesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (linesStream != null) {
                        try {
                            linesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return Collections.emptyList();
                }
            }
            linesStream.close();
        }
        return list;
    }

    List<String[]> getSets() {
        return this.sets;
    }

    public final Confidence getConfidence() {
        return this.confidence;
    }

    protected boolean matches(List<String> lines) {
        ArrayList<String[]> toSearch = new ArrayList<String[]>(this.sets);
        for (String line : lines) {
            Iterator it = toSearch.iterator();
            while (it.hasNext()) {
                String[] set = (String[])it.next();
                if (!Arrays.stream(set).anyMatch(line::contains)) continue;
                it.remove();
                if (!toSearch.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract T createParser(Path var1, UserInteractionHandler var2);

    public static enum Confidence {
        HIGH,
        LOW;

    }
}

