/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4;

import com.azul.log.gui.markup.api.HTMLMarkup;
import com.azul.log.gui.model.spi.TextProvider;
import com.azul.log.gui.model.spi.TooltipProvider;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public final class C4_VMFlags {
    private static final String ZVM_FLAGS_URL = "https://cdn.azul.com/gcla2/zvm-flags/";
    private static final Pattern versionPattern = Pattern.compile("(.*zing_.*-b[0-9]*).*");
    private static final ExecutorService pool = Executors.newCachedThreadPool(r -> new Thread(r, "VMFlags fetcher"){
        {
            this.setDaemon(true);
        }
    });
    private static final Map<String, C4_VMFlags> cache = new HashMap<String, C4_VMFlags>();
    private static final Map<String, List<Runnable>> continuations = new HashMap<String, List<Runnable>>();
    private final Future<Map<String, VMFlag>> map;
    private final AtomicBoolean knownZVMRelease;
    private final String vm_release;

    private C4_VMFlags(Future<Map<String, VMFlag>> map, String vm_release, AtomicBoolean knownZVMRelease) {
        this.map = map;
        this.vm_release = vm_release;
        this.knownZVMRelease = knownZVMRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static C4_VMFlags init(String vm_release, Runnable onLoad) {
        C4_VMFlags result;
        Map<String, C4_VMFlags> map = cache;
        synchronized (map) {
            result = cache.get(vm_release);
            if (result != null) {
                if (!result.map.isDone()) {
                    C4_VMFlags.registerOnLoadHook(vm_release, onLoad);
                }
                return result;
            }
            C4_VMFlags.registerOnLoadHook(vm_release, onLoad);
            AtomicBoolean knownZVMRelease = new AtomicBoolean(false);
            Callable<Map> worker = () -> {
                Map<String, VMFlag> flags = null;
                Matcher m = versionPattern.matcher(vm_release);
                try {
                    if (m.matches()) {
                        flags = C4_VMFlags.fetchFlags(m.group(1));
                        if (flags == null) {
                            flags = vm_release.startsWith("1.7.0") ? C4_VMFlags.fetchFlags("1.7-latest") : (vm_release.startsWith("1.8.0") ? C4_VMFlags.fetchFlags("1.8-latest") : C4_VMFlags.fetchFlags(vm_release.substring(0, 2) + "-latest"));
                        } else {
                            knownZVMRelease.set(true);
                        }
                    }
                    Map<String, VMFlag> map = flags;
                    return map;
                }
                finally {
                    C4_VMFlags.processRegisteredOnLoadHooks(vm_release);
                }
            };
            result = new C4_VMFlags(pool.submit(worker), vm_release, knownZVMRelease);
            cache.put(vm_release, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerOnLoadHook(String vm_release, Runnable onLoad) {
        if (onLoad != null) {
            Map<String, List<Runnable>> map = continuations;
            synchronized (map) {
                if (!continuations.containsKey(vm_release)) {
                    continuations.put(vm_release, new ArrayList<Runnable>(Collections.singletonList(onLoad)));
                } else {
                    continuations.get(vm_release).add(onLoad);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRegisteredOnLoadHooks(String vm_release) {
        List<Runnable> list;
        Map<String, List<Runnable>> map = continuations;
        synchronized (map) {
            if (!continuations.containsKey(vm_release)) {
                return;
            }
            list = continuations.remove(vm_release);
        }
        list.forEach(SwingUtilities::invokeLater);
    }

    public VMFlagEntry getEntry(String flag_name, String value) {
        return new VMFlagEntry(flag_name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, VMFlag> fetchFlags(String version) {
        HashMap<String, VMFlag> result = new HashMap<String, VMFlag>();
        try {
            URL url = new URL(ZVM_FLAGS_URL + version);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), Charset.defaultCharset()));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] split = line.split("\\|", 4);
                    if (split.length != 4) {
                        Map<String, VMFlag> map = null;
                        return map;
                    }
                    result.put(split[0], new VMFlag(split[0], split[1], split[2], split[3]));
                }
                return result;
            }
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String releaseToVMVersion(String releaseVersion) {
        Matcher m = versionPattern.matcher(releaseVersion);
        return m.matches() ? m.group(1) : releaseVersion;
    }

    public static final class Utils {
        public static String getXXFlagValue(String xxFlag) {
            try {
                return Utils.getXXFlagValueUnsafe(xxFlag);
            }
            catch (Exception e) {
                return xxFlag;
            }
        }

        private static String getXXFlagValueUnsafe(String xxFlag) {
            return xxFlag.substring(xxFlag.indexOf(61) + 1);
        }
    }

    public static final class VMFlag {
        public final String kind;
        public final String type;
        public final String name;
        public final String doc;

        private VMFlag(String name, String type, String kind, String doc) {
            this.kind = kind;
            this.type = type;
            this.name = name;
            this.doc = doc;
        }

        private static VMFlag unknown(String name) {
            return new VMFlag(name, null, null, null);
        }
    }

    public final class VMFlagEntry
    implements TooltipProvider,
    TextProvider {
        private final String flagName;
        private final String value;
        private final AtomicReference<String> tooltip = new AtomicReference();
        private final AtomicReference<String> html = new AtomicReference();
        private static final String WARNING_COLOR = "#cd6155";
        private static final String UNKNOWN_FLAG_COLOR = "#d48c21";
        private static final String KNOWN_FLAG_COLOR = "#0a0ae7";

        private VMFlagEntry(String flagName, String value) {
            this.flagName = flagName;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public VMFlag getFlag() {
            if (C4_VMFlags.this.map.isDone()) {
                try {
                    Map<String, VMFlag> m = C4_VMFlags.this.map.get();
                    if (m == null) {
                        return null;
                    }
                    VMFlag flag = m.get(this.flagName);
                    return flag == null ? VMFlag.unknown(this.flagName) : flag;
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(C4_VMFlags.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return null;
        }

        public boolean isKnownZVMRelease() {
            return C4_VMFlags.this.knownZVMRelease.get();
        }

        @Override
        public String getTooltipAtChar(int charIndex) {
            int eq_idx = this.value.indexOf("=");
            if (eq_idx < 0) {
                eq_idx = this.value.length();
            }
            if (charIndex < 0 || charIndex >= eq_idx) {
                return null;
            }
            String result = this.tooltip.get();
            if (result == null) {
                result = this.getDescription(this.getFlag());
                this.tooltip.compareAndSet(null, result);
            }
            return result;
        }

        private String getDescription(VMFlag flag) {
            if (flag == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (flag.type != null) {
                sb.append("<html>[").append(flag.kind).append("] ");
                sb.append(flag.type).append(" ");
                sb.append("<b>").append(flag.name).append("</b>");
                sb.append("<br>").append(flag.doc).append(".");
            } else {
                sb.append("<html>");
                sb.append("<b>").append(flag.name).append("</b>");
                if (this.isKnownZVMRelease()) {
                    sb.append(" is not supported by ").append(C4_VMFlags.this.vm_release).append(". The flag was ignored.");
                } else {
                    sb.append(" is not known by the latest released ZVM version.");
                }
            }
            if (!this.isKnownZVMRelease()) {
                sb.append("<br><hr><font color='#cd6155'>Version ").append(C4_VMFlags.this.vm_release).append(" is not known by this version of LogAnalyzer.").append("<br>Description is taken from the latest released ZVM version ").append(" and could be inaccurate for this log!</font>");
            }
            return sb.toString();
        }

        @Override
        public String asHtml() {
            String result = this.html.get();
            if (result == null) {
                result = this.getHtml(this.getFlag());
                this.html.compareAndSet(null, result);
            }
            return result;
        }

        private String getHtml(VMFlag flag) {
            String param;
            Object name;
            if (flag == null) {
                return this.value;
            }
            StringBuilder content = new StringBuilder();
            int idx = this.value.indexOf(61);
            if (idx > 0) {
                name = this.value.substring(0, idx);
                param = this.value.substring(idx);
            } else {
                name = this.value;
                param = "";
            }
            boolean isSelected = false;
            if (!this.isKnownZVMRelease()) {
                name = (String)name + HTMLMarkup.addHTMLColor(WARNING_COLOR, "<sup><small>*</small></sup>", !isSelected);
            }
            if (flag.type == null || flag.doc.contains("IGNORED!")) {
                content.append(HTMLMarkup.addHTMLColor(UNKNOWN_FLAG_COLOR, "<strike>" + (String)name, !isSelected)).append(param).append("</strike>");
            } else {
                content.append(HTMLMarkup.addHTMLColor(KNOWN_FLAG_COLOR, (String)name, !isSelected)).append(param);
            }
            return content.toString();
        }

        @Override
        public String asText() {
            return this.value;
        }

        public String toString() {
            return this.asText();
        }
    }
}

