/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.records.PSIRecord;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;

@GraphsDescription(model="C4", category="CGroup", position=75, graphs={@GraphDescription(title="Memory Use", units=LogUnits.MEGABYTES, position=60, series={@GraphSeries(source=SysinfoRecord.class, field="cg_mem_limit_bytes", label="CGroup Memory Limit"), @GraphSeries(source=SysinfoRecord.class, field="cg_mem_usage_bytes", label="CGroup Memory Usage"), @GraphSeries(source=SysinfoRecord.class, field="cg_mem_max_usage_bytes", label="CGroup Max Memory Usage"), @GraphSeries(source=SysinfoRecord.class, field="cg_mem_total_rss_bytes", label="CGroup Total RSS"), @GraphSeries(source=SysinfoRecord.class, field="cg_mem_total_shmem_bytes", label="CGroup Total Shmem"), @GraphSeries(source=SysinfoRecord.class, field="cg_mem_total_active_file_bytes", label="CGroup Total Active File"), @GraphSeries(source=SysinfoRecord.class, field="cg_mem_total_inactive_file_bytes", label="CGroup Total Inactive File")}), @GraphDescription(title="CPU Enforcement Counters", ylabel="CPU Period Intervals (in cpu.cfs_period_us)", units=LogUnits.COUNT, position=10, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="cg_cpu_throttle_nof_periods", label="Enforcement"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="cg_cpu_throttle_nof_throttle", label="Throttled/Limited")}), @GraphDescription(title="CPU Throttled Time", units=LogUnits.MILLISECONDS, position=20, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="cg_cpu_throttle_throttled_ms", label="Total Throttled Time")}), @GraphDescription(title="CPU Use", ylabel="Seconds of CPU Time Consumed by All Tasks in the CGroup", units=LogUnits.SECONDS, position=30, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="cg_cpu_usage_ms", label="Total CPU Time"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="cg_cpu_system_usage_ms", label="CPU Time in Kernel Mode"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="cg_cpu_user_usage_ms", label="CPU Time in User Mode")}), @GraphDescription(title="CPU Use Percent (% of Limit)", ylabel="Percent of CPU Time Consumed by All Tasks in the CGroup", units=LogUnits.PERCENT, position=50, series={@GraphSeries(source=SysinfoRecord.class, field="cg_cpu_usage_percent_of_limit", label="Total CPU Percent (Instant)"), @GraphSeries(source=SysinfoRecord.class, field="cg_cpu_usage_percent_of_limit_30", label="Total CPU Percent (Over 30 seconds)"), @GraphSeries(source=SysinfoRecord.class, field="cg_cpu_usage_percent_of_limit_60", label="Total CPU Percent (Over 60 seconds)")}), @GraphDescription(title="CPU Use Percent (% of Request)", ylabel="Percent of CPU Time Consumed by All Tasks in the CGroup", filter=IncludeIfCPUSharesEnabled.class, units=LogUnits.PERCENT, position=50, series={@GraphSeries(source=SysinfoRecord.class, field="cg_cpu_usage_percent_of_request", label="Total CPU Percent (Instant)"), @GraphSeries(source=SysinfoRecord.class, field="cg_cpu_usage_percent_of_request_30", label="Total CPU Percent (Over 30 seconds)"), @GraphSeries(source=SysinfoRecord.class, field="cg_cpu_usage_percent_of_request_60", label="Total CPU Percent (Over 60 seconds)")}), @GraphDescription(title="PSI - CPU Pressure", ylabel="Percent of Time Some or All (Full) Tasks were Stalled due to CPU Contention", position=150, units=LogUnits.PERCENT, series={@GraphSeries(source=PSIRecord.class, field="cgCpuSomeAvg10", label="Some (10s avg)"), @GraphSeries(source=PSIRecord.class, field="cgCpuSomeAvg60", label="Some (60s avg)"), @GraphSeries(source=PSIRecord.class, field="cgCpuSomeAvg300", label="Some (300s avg)"), @GraphSeries(source=PSIRecord.class, field="cgCpuFullAvg10", label="Full (10s avg)"), @GraphSeries(source=PSIRecord.class, field="cgCpuFullAvg60", label="Full (60s avg)"), @GraphSeries(source=PSIRecord.class, field="cgCpuFullAvg300", label="Full (300s avg)")}), @GraphDescription(title="PSI - Memory Pressure", ylabel="Percent of Time Some or All (Full) Tasks were Stalled due to Memory Contention", position=160, units=LogUnits.PERCENT, series={@GraphSeries(source=PSIRecord.class, field="cgMemorySomeAvg10", label="Some (10s avg)"), @GraphSeries(source=PSIRecord.class, field="cgMemorySomeAvg60", label="Some (60s avg)"), @GraphSeries(source=PSIRecord.class, field="cgMemorySomeAvg300", label="Some (300s avg)"), @GraphSeries(source=PSIRecord.class, field="cgMemoryFullAvg10", label="Full (10s avg)"), @GraphSeries(source=PSIRecord.class, field="cgMemoryFullAvg60", label="Full (60s avg)"), @GraphSeries(source=PSIRecord.class, field="cgMemoryFullAvg300", label="Full (300s avg)")}), @GraphDescription(title="PSI - I/O Pressure", ylabel="Percent of Time Some or All (Full) Tasks were Stalled due to I/O Contention", position=170, units=LogUnits.PERCENT, series={@GraphSeries(source=PSIRecord.class, field="cgIoSomeAvg10", label="Some (10s avg)"), @GraphSeries(source=PSIRecord.class, field="cgIoSomeAvg60", label="Some (60s avg)"), @GraphSeries(source=PSIRecord.class, field="cgIoSomeAvg300", label="Some (300s avg)"), @GraphSeries(source=PSIRecord.class, field="cgIoFullAvg10", label="Full (10s avg)"), @GraphSeries(source=PSIRecord.class, field="cgIoFullAvg60", label="Full (60s avg)"), @GraphSeries(source=PSIRecord.class, field="cgIoFullAvg300", label="Full (300s avg)")}), @GraphDescription(title="PSI - Total Stall Time (CPU, Memory, I/O)", position=180, units=LogUnits.MILLISECONDS, ylabel="Total Stall Time in MilliSeconds", series={@GraphSeries(source=PSIRecord.class, field="cgCpuSomeTotal", label="CPU (Some)"), @GraphSeries(source=PSIRecord.class, field="cgCpuFullTotal", label="CPU (Full)"), @GraphSeries(source=PSIRecord.class, field="cgMemorySomeTotal", label="Memory (Some)"), @GraphSeries(source=PSIRecord.class, field="cgMemoryFullTotal", label="Memory (Full)"), @GraphSeries(source=PSIRecord.class, field="cgIoSomeTotal", label="I/O (Some)"), @GraphSeries(source=PSIRecord.class, field="cgIoFullTotal", label="I/O (Full)")})})
public final class CGroupGraphsDescription
extends GraphsDefinitionProvider {

    public static final class IncludeIfCPUSharesEnabled
    implements GraphDescriptionFilter {
        @Override
        public boolean isApplicable(LogModel logModel) {
            return SysinfoRecord.isCPUSharesDefined();
        }
    }
}

