/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.DistinctGraphDescription;
import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.api.Aggregation;
import com.azul.log.parser.impl.c4.records.DeoptstatsRecord;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DeoptstatsGraphsDescription
extends GraphsDefinitionProvider {
    @Override
    public Collection<? extends GraphDefinition> getGraphsDefinition(LogModel logModel) {
        ArrayList graphDefinitionList = new ArrayList();
        for (TIER tier : TIER.values()) {
            for (DEOPT_KIND deoptKind : DEOPT_KIND.values()) {
                graphDefinitionList.addAll(logModel.getRecordsMap().keySet().stream().filter(DeoptstatsRecord.class::isAssignableFrom).map(klass -> new DeoptstatsGraphsDescriptionImpl(tier, deoptKind, (Class<? extends DeoptstatsRecord>)klass)).map(gd -> this.createDefinitions(logModel, (GraphsDescription)gd)).flatMap(Collection::stream).collect(Collectors.toList()));
            }
        }
        return graphDefinitionList;
    }

    static enum TIER {
        TIER1("1"),
        TIER2("2");

        final String tier;

        private TIER(String tier) {
            this.tier = tier;
        }

        public String toString() {
            return this.tier;
        }
    }

    static enum DEOPT_KIND {
        ENTRANT("Entrant", "_entr"),
        NON_ENTRANT("Non-Entrant", "_nonentr");

        final String displayName;
        final String fieldSuffix;

        private DEOPT_KIND(String displayName, String fieldSuffix) {
            this.displayName = displayName;
            this.fieldSuffix = fieldSuffix;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static final class DeoptstatsGraphsDescriptionImpl
    implements GraphsDescription {
        private final TIER tier;
        private final DEOPT_KIND deoptKind;
        private final Class<? extends DeoptstatsRecord> klass;

        public DeoptstatsGraphsDescriptionImpl(TIER tier, DEOPT_KIND deoptKind, Class<? extends DeoptstatsRecord> klass) {
            this.tier = tier;
            this.deoptKind = deoptKind;
            this.klass = klass;
        }

        @Override
        public String model() {
            return "C4";
        }

        @Override
        public String category() {
            return "Deopt Statistics";
        }

        @Override
        public GraphDescription[] graphs() {
            return new GraphDescription[]{new GraphDescriptionImpl(this.deoptKind)};
        }

        @Override
        public DistinctGraphDescription[] distinct_graphs() {
            return new DistinctGraphDescription[0];
        }

        @Override
        public int position() {
            return 85;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return GraphDescription.class;
        }

        private final class GraphSeriesImpl
        implements GraphSeries {
            private final String name;
            private final String field;

            GraphSeriesImpl(String name, String field) {
                this.name = name;
                this.field = field;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public Class<? extends LogRecord> source() {
                return DeoptstatsGraphsDescriptionImpl.this.klass;
            }

            @Override
            public String label() {
                return this.name;
            }

            @Override
            public String field() {
                return this.field;
            }

            @Override
            public String color() {
                return "";
            }

            @Override
            public String filter() {
                return "";
            }

            @Override
            public String default_state() {
                return "";
            }

            @Override
            public String filter_field() {
                return "tier";
            }

            @Override
            public String filter_value() {
                return DeoptstatsGraphsDescriptionImpl.this.tier.toString();
            }

            @Override
            public String distinct_field() {
                return "";
            }

            @Override
            public Aggregation aggregation() {
                return Aggregation.UNSPECIFIED;
            }

            @Override
            public Class<? extends ColorsProvider> colors_provider() {
                return ColorsProvider.Default.class;
            }
        }

        final class GraphDescriptionImpl
        implements GraphDescription {
            private final List<String> excludeFields = List.of("tier", "end_s");
            private final GraphSeries[] series;

            public GraphDescriptionImpl(DEOPT_KIND deoptKind) {
                this.series = Arrays.stream(DeoptstatsGraphsDescriptionImpl.this.klass.getDeclaredFields()).filter(field -> !this.excludeFields.contains(field.getName())).filter(field -> field.getName().endsWith(deoptKind.fieldSuffix)).map(field -> {
                    String fieldName = field.getName();
                    String chartName = fieldName.replace(deoptKind.fieldSuffix, "");
                    return new GraphSeriesImpl(chartName, fieldName);
                }).collect(Collectors.toList()).toArray(new GraphSeries[0]);
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return GraphDescription.class;
            }

            @Override
            public String title() {
                return "Tier " + DeoptstatsGraphsDescriptionImpl.this.tier + " Deopt Counts (" + DeoptstatsGraphsDescriptionImpl.this.deoptKind + ")";
            }

            @Override
            public int position() {
                return DeoptstatsGraphsDescriptionImpl.this.tier.ordinal() * 10 + DeoptstatsGraphsDescriptionImpl.this.deoptKind.ordinal();
            }

            @Override
            public GraphSeries[] series() {
                return this.series;
            }

            @Override
            public LogUnits units() {
                return LogUnits.METHODS;
            }

            @Override
            public String xlabel() {
                return "Elapsed Time";
            }

            @Override
            public String ylabel() {
                return LogUnits.METHODS.getAbbreviation();
            }

            @Override
            public Class<? extends SeriesComparator> series_comparator() {
                return SeriesComparator.Default.class;
            }

            @Override
            public Class<? extends LogRecordLabelConverter> label_converter() {
                return GraphDescription.DefaultLabelConverter.class;
            }

            @Override
            public Class<? extends GraphDescriptionFilter> filter() {
                return GraphDescription.DefaultGraphDescriptionFilter.class;
            }
        }
    }
}

