/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.gui.ui.ColorPalette;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.records.HugePageStatRecord;
import com.azul.log.parser.impl.c4.records.PSIRecord;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;
import com.azul.log.parser.impl.c4.records.SystemThreadCpuUsageRecord;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@GraphsDescription(model="C4", category="System", position=70, graphs={@GraphDescription(title="Memory Use", position=40, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="sysMemUsed", label="System Memory Used"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="sysMemMax", label="System Memory Max"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="memAvailable", label="System Memory Available")}), @GraphDescription(title="Swap Memory", position=70, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="swapUsed", label="Swap Memory Used"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="swapMax", label="Swap Memory Max")}), @GraphDescription(title="Load Average", ylabel="Threads Runnable", position=20, units=LogUnits.THREADS, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="load1", label="Average over Last 1 Minute"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="load5", label="Average over Last 5 Minutes"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="load15", label="Average over Last 15 Minutes")}), @GraphDescription(title="Paging Behavior", ylabel="Pages Since Program Start", position=50, units=LogUnits.PAGES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="delta_pageIn", label="Pages In"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="delta_pageOut", label="Pages Out")}), @GraphDescription(title="Swapping Behavior", position=80, ylabel="Pages Since Program Start", units=LogUnits.PAGES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="delta_swapPageIn", label="Swap Pages In"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="delta_swapPageOut", label="Swap Pages Out")}), @GraphDescription(title="Linux Memory and Page Cache Use", position=10, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="sysLinuxMemTotal", label="System Linux Memory Total"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="cacheUseTotal", label="Page Cache Memory Use Total"), @GraphSeries(color="#DF833E", source=SysinfoRecord.class, field="cacheActiveFile", label="Page Cache Active (File)"), @GraphSeries(color="#9EB6D2", source=SysinfoRecord.class, field="cacheInactiveFile", label="Page Cache Inactive (File)"), @GraphSeries(color="#48A7B9", source=SysinfoRecord.class, field="cacheActiveAnon", label="Page Cache Active (Anon)"), @GraphSeries(color="#82559A", source=SysinfoRecord.class, field="cacheInactiveAnon", label="Page Cache Inactive (Anon)"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="swapCached", label="SwapCached"), @GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="buffers", label="Buffers (I/O)"), @GraphSeries(color="#0ABCC8", source=SysinfoRecord.class, field="unevictable", label="Unevictable"), @GraphSeries(color="#D20A3E", source=SysinfoRecord.class, field="mlocked", label="MLocked"), @GraphSeries(color="#808080", source=SysinfoRecord.class, field="mapped", label="Mapped"), @GraphSeries(color="#00A000", source=SysinfoRecord.class, field="dirty", label="Dirty (Waiting to be written to disk)")}), @GraphDescription(title="System Zing Memory Total and Use", position=90, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="sysZingMemTot", label="System Zing Memory Total (for Partition)"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="sysZingReservableTot", label="System Zing Reservable Memory Total"), @GraphSeries(color="#DF833E", source=SysinfoRecord.class, field="sysZingReservableUsed", label="System Zing Reservable Memory Used"), @GraphSeries(color="#9EB6D2", source=SysinfoRecord.class, field="sysZingContMemTot", label="System Zing Contingency Memory Total"), @GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="sysZingContMemUsed", label="System Zing Contingency Memory Used"), @GraphSeries(color="#826B9A", source=SysinfoRecord.class, field="sysZingPPMemTot", label="System Zing Pause Prevention Memory Total"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="sysZingPPMemUsed", label="System Zing Pause Prevention Memory Used")}), @GraphDescription(title="Threads Blocked/Running/Total", position=130, units=LogUnits.PROCESSES, ylabel="Count", series={@GraphSeries(color="#DF833E", source=SysinfoRecord.class, field="procsBlocked", label="Threads Blocked"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="procsRunning", label="Threads Running"), @GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="procsTotal", label="Threads Total")}), @GraphDescription(title="Threads Total Launched Since Program Start", position=140, units=LogUnits.PROCESSES, ylabel="Count", series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="delta_processes", label="Total Threads Launched Since Zing VM Start")}), @GraphDescription(title="THP Allocation", position=100, units=LogUnits.PAGES, ylabel="Pages Allocated Since Program Start", series={@GraphSeries(source=HugePageStatRecord.class, field="thp_fault_alloc", label="Huge Page allocated (thp_fault_alloc)"), @GraphSeries(source=HugePageStatRecord.class, field="thp_fault_fallback", label="Fallbacks to Small Pages allocation (thp_fault_fallback)"), @GraphSeries(source=HugePageStatRecord.class, field="thp_file_alloc", label="File Huge Page allocated (thp_file_alloc)")}), @GraphDescription(title="THP Mapping", position=110, units=LogUnits.MEGABYTES, ylabel="Megabytes Mapped Since Program Start", series={@GraphSeries(source=HugePageStatRecord.class, field="anon_huge_pages", label="Non-file backed HP (AnonHugePages)"), @GraphSeries(source=HugePageStatRecord.class, field="shmem_pmd_mapped", label="Shared memory mapped with HP (ShmemPmdMapped)"), @GraphSeries(source=HugePageStatRecord.class, field="shmem_huge_pages", label="Shared memory + tmpfs allocated with HP (ShmemHugePages)")}), @GraphDescription(title="Static Huge Pages", position=60, units=LogUnits.MEGABYTES, ylabel="Megabytes", series={@GraphSeries(source=HugePageStatRecord.class, field="huge_pages_total_mb", label="Total Memory Reserved for Static Huge Pages"), @GraphSeries(source=HugePageStatRecord.class, field="huge_pages_free_mb", label="Available Memory in Reserved Static Huge Pages")}), @GraphDescription(title="Memory Compaction", position=30, units=LogUnits.COUNT, ylabel="Compactions Since Program Start", series={@GraphSeries(source=HugePageStatRecord.class, field="compact_stall", label="A Process Stalls for Memory Compaction"), @GraphSeries(source=HugePageStatRecord.class, field="compact_success", label="Successful Memory Compaction"), @GraphSeries(source=HugePageStatRecord.class, field="compact_fail", label="Failed Memory Compaction"), @GraphSeries(source=HugePageStatRecord.class, field="compact_pages_moved", label="Page moved")}), @GraphDescription(title="Thread CPU usage", position=120, units=LogUnits.CORES, ylabel="CPU Utilization (cores)", series_comparator=SystemThreadCpuUsageRecordSeriesComparator.class, series={@GraphSeries(source=SystemThreadCpuUsageRecord.class, field="cores", distinct_field="threadName", label="{dv}", colors_provider=SystemThreadCpuUsageRecordColorsProvider.class)}), @GraphDescription(title="PSI - CPU Pressure", ylabel="Percent of Time Some or All (Full) Tasks were Stalled due to CPU Contention", position=150, units=LogUnits.PERCENT, series={@GraphSeries(source=PSIRecord.class, field="sysCpuSomeAvg10", label="Some (10s avg)"), @GraphSeries(source=PSIRecord.class, field="sysCpuSomeAvg60", label="Some (60s avg)"), @GraphSeries(source=PSIRecord.class, field="sysCpuSomeAvg300", label="Some (300s avg)"), @GraphSeries(source=PSIRecord.class, field="sysCpuFullAvg10", label="Full (10s avg)"), @GraphSeries(source=PSIRecord.class, field="sysCpuFullAvg60", label="Full (60s avg)"), @GraphSeries(source=PSIRecord.class, field="sysCpuFullAvg300", label="Full (300s avg)")}), @GraphDescription(title="PSI - Memory Pressure", ylabel="Percent of Time Some or All (Full) Tasks were Stalled due to Memory Contention", position=160, units=LogUnits.PERCENT, series={@GraphSeries(source=PSIRecord.class, field="sysMemorySomeAvg10", label="Some (10s avg)"), @GraphSeries(source=PSIRecord.class, field="sysMemorySomeAvg60", label="Some (60s avg)"), @GraphSeries(source=PSIRecord.class, field="sysMemorySomeAvg300", label="Some (300s avg)"), @GraphSeries(source=PSIRecord.class, field="sysMemoryFullAvg10", label="Full (10s avg)"), @GraphSeries(source=PSIRecord.class, field="sysMemoryFullAvg60", label="Full (60s avg)"), @GraphSeries(source=PSIRecord.class, field="sysMemoryFullAvg300", label="Full (300s avg)")}), @GraphDescription(title="PSI - I/O Pressure", ylabel="Percent of Time Some or All (Full) Tasks were Stalled due to I/O Contention", position=170, units=LogUnits.PERCENT, series={@GraphSeries(source=PSIRecord.class, field="sysIoSomeAvg10", label="Some (10s avg)"), @GraphSeries(source=PSIRecord.class, field="sysIoSomeAvg60", label="Some (60s avg)"), @GraphSeries(source=PSIRecord.class, field="sysIoSomeAvg300", label="Some (300s avg)"), @GraphSeries(source=PSIRecord.class, field="sysIoFullAvg10", label="Full (10s avg)"), @GraphSeries(source=PSIRecord.class, field="sysIoFullAvg60", label="Full (60s avg)"), @GraphSeries(source=PSIRecord.class, field="sysIoFullAvg300", label="Full (300s avg)")}), @GraphDescription(title="PSI - Total Stall Time (CPU, Memory, I/O)", position=180, units=LogUnits.MILLISECONDS, ylabel="Total Stall Time in MilliSeconds", series={@GraphSeries(source=PSIRecord.class, field="sysCpuSomeTotal", label="CPU (Some)"), @GraphSeries(source=PSIRecord.class, field="sysCpuFullTotal", label="CPU (Full)"), @GraphSeries(source=PSIRecord.class, field="sysMemorySomeTotal", label="Memory (Some)"), @GraphSeries(source=PSIRecord.class, field="sysMemoryFullTotal", label="Memory (Full)"), @GraphSeries(source=PSIRecord.class, field="sysIoSomeTotal", label="I/O (Some)"), @GraphSeries(source=PSIRecord.class, field="sysIoFullTotal", label="I/O (Full)")})})
public final class SysinfoGraphsDescription
extends GraphsDefinitionProvider {
    private static final String LBL_TOTAL = "TOTAL";
    private static final String LBL_OTHER = "OTHER";

    public static class SystemThreadCpuUsageRecordSeriesComparator
    implements SeriesComparator {
        @Override
        public int compare(DataSeries s1, DataSeries s2) {
            String l2;
            String l1 = s1.getLabel();
            return Objects.equals(l1, l2 = s2.getLabel()) ? 0 : (SysinfoGraphsDescription.LBL_TOTAL.equals(l1) ? 1 : (SysinfoGraphsDescription.LBL_TOTAL.equals(l2) ? -1 : (SysinfoGraphsDescription.LBL_OTHER.equals(l1) ? 1 : (SysinfoGraphsDescription.LBL_OTHER.equals(l2) ? -1 : l1.compareTo(l2)))));
        }
    }

    public static class SystemThreadCpuUsageRecordColorsProvider
    implements ColorsProvider {
        private final Map<String, Color> colors = new HashMap<String, Color>();
        private final Iterator<Color> iterator = ColorPalette.iterator();

        public SystemThreadCpuUsageRecordColorsProvider() {
            this.colors.put(SysinfoGraphsDescription.LBL_TOTAL, Color.decode("#AC3E39"));
            this.colors.put(SysinfoGraphsDescription.LBL_OTHER, Color.decode("#DF833E"));
        }

        @Override
        public Color getColor(String value) {
            Color color = this.colors.get(value);
            if (color != null) {
                return color;
            }
            color = this.iterator.next();
            while (this.colors.containsValue(color)) {
                color = this.iterator.next();
            }
            return color;
        }
    }
}

