/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.custom;

import com.azul.log.gui.graphs.annotations.DistinctGraphDescription;
import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.api.Aggregation;
import com.azul.log.parser.impl.c4.custom.C4_CustomLineParsersSupport;
import com.azul.log.parser.utils.TextUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import mjson.Json;

public final class C4_CustomGraphsDefinitionProvider
extends GraphsDefinitionProvider {
    private static Set<GraphsDescription> createGraphDescriptions(String modelID, Json graphs) {
        if (graphs == null || !graphs.isArray()) {
            return Collections.emptySet();
        }
        return graphs.asJsonList().stream().map(json -> C4_CustomGraphsDefinitionProvider.createGraphDescription(modelID, json)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static GraphsDescription createGraphDescription(String modelID, Json graphsData) {
        try {
            String category = (String)graphsData.asMap().get("category");
            ArrayList gds = new ArrayList();
            Json chartsNode = graphsData.asJsonMap().get("charts");
            chartsNode.asJsonList().forEach(chartData -> {
                Map<String, Object> chartsMap = chartData.asMap();
                String name = (String)chartsMap.get("name");
                LogUnits units = LogUnits.safeValueOf(chartsMap.get("data_units"));
                String data_label = (String)chartsMap.get("data_label");
                Json seriesNode = chartData.asJsonMap().get("series");
                List<GraphSeries> series = seriesNode.asJsonList().stream().map(Json::asMap).map(x$0 -> GraphSeriesImpl.create(x$0)).filter(Objects::nonNull).collect(Collectors.toList());
                gds.add(new GraphDescriptionImpl(data_label, Integer.MAX_VALUE, name, units, series));
            });
            return new GraphsDescriptionImpl(modelID, category, Integer.MAX_VALUE, gds.toArray(new GraphDescription[0]), new DistinctGraphDescription[0]);
        }
        catch (Throwable ex) {
            Logger.getLogger(C4_CustomGraphsDefinitionProvider.class.getName()).log(Level.SEVERE, "Failed to generate custom graphs.", ex);
            return null;
        }
    }

    @Override
    public Collection<? extends GraphDefinition> getGraphsDefinition(LogModel logModel) {
        String modelID = logModel.getModelID();
        Json customJson = C4_CustomLineParsersSupport.getCustomJson(modelID);
        return customJson == null ? Collections.emptyList() : (Collection)C4_CustomGraphsDefinitionProvider.createGraphDescriptions(modelID, customJson.asJsonMap().get("graphs")).stream().map(d -> this.createDefinitions(logModel, (GraphsDescription)d)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class GraphsDescriptionImpl
    implements GraphsDescription {
        private final String modelID;
        private final GraphDescription[] graphs;
        private final String category;
        private final int position;
        private final DistinctGraphDescription[] distinct_graphs;

        public GraphsDescriptionImpl(String modelID, String category, int position, GraphDescription[] graphs, DistinctGraphDescription[] distinct_graphs) {
            this.modelID = modelID;
            this.category = category;
            this.position = position;
            this.graphs = graphs;
            this.distinct_graphs = distinct_graphs;
        }

        @Override
        public GraphDescription[] graphs() {
            return this.graphs;
        }

        @Override
        public String category() {
            return this.category;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public DistinctGraphDescription[] distinct_graphs() {
            return this.distinct_graphs;
        }

        @Override
        public String model() {
            return this.modelID;
        }
    }

    private static class GraphSeriesImpl
    implements GraphSeries {
        private final String filter;
        private final String label;
        private final String color;
        private final String field;
        private final String filter_field;
        private final String filter_value;
        private final String default_state;
        private final String distinct_field;
        private final Class<? extends LogRecord> source;
        private final Aggregation aggregation;

        private GraphSeriesImpl(Map<String, Object> seriesData) throws ClassNotFoundException {
            this.label = (String)seriesData.get("label");
            this.color = (String)seriesData.get("color");
            this.field = (String)seriesData.get("field");
            this.filter = seriesData.containsKey("filter") ? (String)seriesData.get("filter") : "";
            this.filter_field = seriesData.containsKey("filter_field") ? (String)seriesData.get("filter_field") : "";
            this.filter_value = seriesData.containsKey("filter_value") ? (String)seriesData.get("filter_value") : "";
            this.default_state = seriesData.containsKey("default_state") ? (String)seriesData.get("default_state") : "";
            this.distinct_field = seriesData.containsKey("distinct_field") ? (String)seriesData.get("distinct_field") : "";
            this.aggregation = Aggregation.safeValueOf(seriesData.get("aggregation"));
            String source_class = TextUtils.toValidJavaIdentifier("c_", (String)seriesData.get("class"));
            Class<Object> c = null;
            try {
                c = C4_CustomLineParsersSupport.getClass(source_class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                try {
                    c = Class.forName("com.azul.log.parser.impl.c4.records." + source_class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(source_class);
            }
            this.source = c;
        }

        private static GraphSeriesImpl create(Map<String, Object> seriesData) {
            try {
                return new GraphSeriesImpl(seriesData);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(C4_CustomGraphsDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public String color() {
            return this.color;
        }

        @Override
        public Class<? extends LogRecord> source() {
            return this.source;
        }

        @Override
        public String field() {
            return this.field;
        }

        @Override
        public String filter() {
            return this.filter;
        }

        @Override
        public String filter_field() {
            return this.filter_field;
        }

        @Override
        public String filter_value() {
            return this.filter_value;
        }

        @Override
        public Aggregation aggregation() {
            return this.aggregation;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public String distinct_field() {
            return this.distinct_field;
        }

        @Override
        public String default_state() {
            return this.default_state;
        }

        @Override
        public Class<? extends ColorsProvider> colors_provider() {
            return ColorsProvider.Default.class;
        }
    }

    private static class GraphDescriptionImpl
    implements GraphDescription {
        private final String xlabel;
        private final String ylabel;
        private final int position;
        private final String title;
        private final GraphSeries[] graphSeries;
        private final LogUnits units;

        public GraphDescriptionImpl(String ylabel, int position, String title, LogUnits units, List<GraphSeries> graphSeries) {
            this.xlabel = "Elapsed Time";
            this.ylabel = ylabel == null ? "" : ylabel;
            this.position = position;
            this.title = title;
            this.graphSeries = graphSeries.toArray(new GraphSeries[0]);
            this.units = units;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public GraphSeries[] series() {
            return this.graphSeries;
        }

        @Override
        public String xlabel() {
            return this.xlabel;
        }

        @Override
        public String ylabel() {
            return this.ylabel;
        }

        @Override
        public Class<? extends LogRecordLabelConverter> label_converter() {
            return GraphDescription.DefaultLabelConverter.class;
        }

        @Override
        public Class<? extends SeriesComparator> series_comparator() {
            return SeriesComparator.Default.class;
        }

        @Override
        public Class<? extends GraphDescriptionFilter> filter() {
            return GraphDescription.DefaultGraphDescriptionFilter.class;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public LogUnits units() {
            return this.units;
        }
    }
}

