/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.metrics;

import com.azul.log.gui.graphs.annotations.DistinctGraphDescription;
import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.api.Aggregation;
import com.azul.log.parser.impl.metrics.Metrics_Parser;
import com.azul.log.parser.spi.annotations.LogLineField;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

final class MetricsGraphsDescription
implements GraphsDescription {
    private final String title;
    private final Class<? extends Metrics_Parser.Metrics_Record> klass;

    public MetricsGraphsDescription(String title, Class<? extends Metrics_Parser.Metrics_Record> klass) {
        this.title = title;
        this.klass = klass;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return GraphsDescription.class;
    }

    @Override
    public String model() {
        return "Metrics";
    }

    @Override
    public String category() {
        return "Metrics";
    }

    @Override
    public GraphDescription[] graphs() {
        return new GraphDescription[]{new GraphDescriptionImpl()};
    }

    @Override
    public DistinctGraphDescription[] distinct_graphs() {
        return new DistinctGraphDescription[0];
    }

    @Override
    public int position() {
        return 0;
    }

    private final class GraphSeriesImpl
    implements GraphSeries {
        private final String name;
        private final String field;

        GraphSeriesImpl(String name, String field) {
            this.name = name;
            this.field = field;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public Class<? extends LogRecord> source() {
            return MetricsGraphsDescription.this.klass;
        }

        @Override
        public String label() {
            return this.name;
        }

        @Override
        public String field() {
            return this.field;
        }

        @Override
        public String color() {
            return "";
        }

        @Override
        public String filter() {
            return "";
        }

        @Override
        public String default_state() {
            return "";
        }

        @Override
        public String filter_field() {
            return "";
        }

        @Override
        public String filter_value() {
            return "";
        }

        @Override
        public String distinct_field() {
            return "";
        }

        @Override
        public Aggregation aggregation() {
            return Aggregation.UNSPECIFIED;
        }

        @Override
        public Class<? extends ColorsProvider> colors_provider() {
            return ColorsProvider.Default.class;
        }
    }

    private final class GraphDescriptionImpl
    implements GraphDescription {
        private final GraphSeries[] series;
        private final LogUnits units;
        private final String ylabel;

        public GraphDescriptionImpl() {
            HashSet fieldUnits = new HashSet();
            this.series = Arrays.stream(MetricsGraphsDescription.this.klass.getDeclaredFields()).map(f -> {
                String field = f.getName();
                Optional<LogLineField> annotation = Optional.ofNullable(f.getAnnotation(LogLineField.class));
                String name = annotation.map(LogLineField::name).orElse(field);
                fieldUnits.add(annotation.map(LogLineField::defaultUnits).orElse(LogUnits.UNSPECIFIED));
                return new GraphSeriesImpl(name, field);
            }).collect(Collectors.toList()).toArray(new GraphSeries[0]);
            this.units = fieldUnits.size() == 1 ? (LogUnits)((Object)fieldUnits.iterator().next()) : LogUnits.UNSPECIFIED;
            this.ylabel = this.units.getAbbreviation().isEmpty() ? "Value" : this.units.getAbbreviation();
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return GraphDescription.class;
        }

        @Override
        public String title() {
            return MetricsGraphsDescription.this.title;
        }

        @Override
        public int position() {
            return 0;
        }

        @Override
        public GraphSeries[] series() {
            return this.series;
        }

        @Override
        public LogUnits units() {
            return this.units;
        }

        @Override
        public String xlabel() {
            return "Elapsed Time";
        }

        @Override
        public String ylabel() {
            return this.ylabel;
        }

        @Override
        public Class<? extends SeriesComparator> series_comparator() {
            return SeriesComparator.Default.class;
        }

        @Override
        public Class<? extends LogRecordLabelConverter> label_converter() {
            return GraphDescription.DefaultLabelConverter.class;
        }

        @Override
        public Class<? extends GraphDescriptionFilter> filter() {
            return GraphDescription.DefaultGraphDescriptionFilter.class;
        }
    }
}

