/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.time.EpochTime;
import com.azul.jvm.time.VmTime;
import com.azul.tools.profile2xlog.impl.LogDecorator;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.StringJoiner;

public class LogWriter {
    private final PrintWriter delegate;
    private final LogDecorator decorator;
    private EpochTime vmStartTime;

    public LogWriter(PrintWriter delegate, LogDecorator decorator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.decorator = Objects.requireNonNull(decorator, "decorator");
    }

    public void setVmStartTime(EpochTime vmStartTime) {
        this.vmStartTime = vmStartTime;
    }

    public EpochTime getVmStartTime() {
        return this.vmStartTime;
    }

    public void writeHeader(String tag, String ... fields) {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(tag + "H");
        for (String field : fields) {
            joiner.add(field);
        }
        this.delegate.println(this.decorator.decorate(VmTime.ZERO, joiner.toString()));
    }

    public void writeLine(EpochTime time, String tag, Object ... fields) {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(tag);
        for (Object field : fields) {
            String value = field == null ? "" : String.valueOf(field).trim();
            joiner.add(value.isEmpty() ? "N/A" : value);
        }
        this.delegate.println(this.decorator.decorate(VmTime.compute(this.vmStartTime, time), joiner.toString()));
    }

    public void writeLine(VmTime time, String tag, Object ... fields) {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(tag);
        for (Object field : fields) {
            String value = field == null ? "" : String.valueOf(field).trim();
            joiner.add(value.isEmpty() ? "N/A" : value);
        }
        this.delegate.println(this.decorator.decorate(time, joiner.toString()));
    }
}

