/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.text.Line;
import com.azul.gulp.text.RegexMatcher;
import com.azul.gulp.text.support.RegexLineMatcher;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.CompileData;
import com.azul.jvm.compile.CompileEventBuilder;
import com.azul.jvm.compile.CompileStarted;
import com.azul.jvm.compile.StashFlavor;
import java.util.Objects;
import java.util.regex.Pattern;

public final class DusterCompilationLineMatcher
extends RegexLineMatcher<CompileStarted> {
    private static final Pattern COMPILE_PATTERN = Pattern.compile("\\s*(\\d+)\\s*([ n])([ \\%])([ s])([ \\!])\\s*([ r]{0,1})\\s*([123])\\s+([\\w\\d\\.\\:\\$\\<\\>\\/]*)\\s+([\\w\\d\\/\\;\\[\\$\\<\\>\\(\\)]*)\\s*\\@{0,1}\\s*(\\d*)\\s*\\(([-\\d]+) score\\)\\s+\\(([-\\d]+) bytes\\).*");

    public DusterCompilationLineMatcher() {
        super(COMPILE_PATTERN);
    }

    @Override
    public final CompileStarted fromMatch(Line line, RegexMatcher matcher) throws Exception {
        if (line.endsWith("made not entrant")) {
            return null;
        }
        DusterCompileEventBuilder compBuilder = new DusterCompileEventBuilder();
        compBuilder.id(matcher.nextInt());
        compBuilder.native_(matcher.nextChar().equals(Character.valueOf('n')));
        compBuilder.osr(matcher.nextChar().equals(Character.valueOf('%')));
        compBuilder.synchronized_(matcher.nextChar().equals(Character.valueOf('s')));
        compBuilder.handlesExceptions(matcher.nextChar().equals(Character.valueOf('!')));
        compBuilder.replacement(Objects.equals(matcher.nextChar(), Character.valueOf('r')));
        compBuilder.zingCompilerNum(matcher.nextInt());
        compBuilder.methodName(matcher.nextString());
        compBuilder.signature(matcher.nextString());
        Integer osrBci = matcher.nextInt();
        if (osrBci != null) {
            compBuilder.osr(osrBci);
        }
        compBuilder.score(matcher.nextInt());
        compBuilder.bytes(matcher.nextInt());
        return compBuilder.makeCompile();
    }

    private static class DusterCompileEventBuilder
    extends CompileEventBuilder.Base<DusterCompileEventBuilder> {
        Boolean replacement;

        private DusterCompileEventBuilder() {
        }

        public DusterCompileEventBuilder replacement() {
            return this.replacement(true);
        }

        public DusterCompileEventBuilder replacement(boolean replacement) {
            this.replacement = replacement;
            return this;
        }

        public DusterCompileEventBuilder zingCompilerNum(int compilerNum) {
            switch (compilerNum) {
                case 1: {
                    this.tier(CompilationTier.TIER_1);
                    this.compilerId(1);
                    this.compiler("c1");
                    break;
                }
                case 2: {
                    this.tier(CompilationTier.TIER_2);
                    this.compilerId(2);
                    this.compiler("c2");
                    break;
                }
                case 3: {
                    this.tier(CompilationTier.TIER_2);
                    this.compilerId(3);
                    this.compiler("falcon");
                    break;
                }
                default: {
                    throw new IllegalStateException("bad compiler ID");
                }
            }
            return this;
        }

        public final CompileData makeCompileData() {
            return new CompileData(this.id, this.native_, this.osr, this.synchronized_, this.handlesExceptions, this.replacement, this.compilerId, this.tier, this.methodName, this.sig, this.entryBci, null, this.score, this.bytes, CompilationTrigger.UNKNOWN, StashFlavor.DEFAULT, null, null, null, null, null, null, -1L, null);
        }

        public final CompileStarted makeCompile() {
            return new CompileStarted(this.makeCompileData(), null);
        }
    }
}

