/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.Emitter;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.gulp.text.RegexMatcher;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompileInstalled;
import com.azul.jvm.compile.CompilerId;
import java.util.regex.Pattern;

public final class PreludeCompilationInstallationLineMatcherV3
implements LineMatcher<CompileInstalled> {
    private static final Pattern REGULAR_PATTERN = Pattern.compile("\\s*(\\d+)\\s+([123])\\s+installed at 0x([\\dabcdef]+) with size 0x([\\dabcdef]+)\\s+\\(\\s+([\\w\\d\\.\\:\\$\\<\\>\\/]*) waited (\\d+) ms\\, compile time (\\d+) \\/ (\\d+) ms\\s+\\).*");
    private static final Pattern FROM_STASH_PATTERN = Pattern.compile("\\s*(\\d+)\\s+([123])\\s+installed at 0x([\\dabcdef]+) with size 0x([\\dabcdef]+)\\s+from object cache\\s+\\(\\s*([\\w\\d\\.\\:\\$\\<\\>\\/]*) waited (\\d+) ms\\, compile time (\\d+) \\/ (\\d+) ms\\s+\\).*");

    @Override
    public void process(Line line, Emitter<CompileInstalled> emitter) throws Exception {
        if (!line.contains("installed at")) {
            return;
        }
        RegexMatcher regMatcher = line.match(REGULAR_PATTERN);
        if (regMatcher.matches()) {
            emitter.fire(this.fromMatch(line, regMatcher, false));
            return;
        }
        RegexMatcher stashMatcher = line.match(FROM_STASH_PATTERN);
        if (stashMatcher.matches()) {
            emitter.fire(this.fromMatch(line, stashMatcher, true));
            return;
        }
    }

    private CompileInstalled fromMatch(Line line, RegexMatcher matcher, boolean fromStash) throws Exception {
        CompilationId compileId = CompilationId.of(matcher.nextInt());
        int rawCompilerNum = matcher.nextInt();
        CompilerId compilerId = CompilerId.fromInt(rawCompilerNum);
        MemoryAddress address = MemoryAddress.of(matcher.nextLong(16));
        int size = matcher.nextInt(16);
        String methodName = matcher.nextString();
        boolean hitStash = fromStash;
        double waitTimeMs = matcher.nextDouble();
        double cpuCompileTimeMs = matcher.nextDouble();
        double wallclockCompileTimeMs = matcher.nextDouble();
        return new CompileInstalled(compileId, compilerId, compilerId.tier(), methodName, address, size, hitStash, waitTimeMs, cpuCompileTimeMs, wallclockCompileTimeMs);
    }
}

