/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.jvm.compile.CompileFailed;
import com.azul.zing.console.matchers.ZephyrCompileLineMatcher;
import com.azul.zing.console.matchers.ZephyrCompileLineParser;
import com.azul.zing.console.matchers.ZingCompileEventBuilder;

public class ZephyrCompileFailedLineMatcher
extends ZephyrCompileLineMatcher<CompileFailed> {
    public ZephyrCompileFailedLineMatcher() {
        super("failed to compile");
    }

    @Override
    protected void processPreamble(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        parser.expect(". ");
        String reason = parser.readStringPhrase();
        if (reason.contains("failed generation check during instalation.")) {
            builder.reason("gen_check");
        } else if (reason.contains("Stash-only compile didn")) {
            builder.reason("stash");
        } else if (reason.contains("concurrent class loading.")) {
            builder.reason("dep_fail");
        } else if (reason.contains("call site target change")) {
            builder.reason("call_site");
        } else if (reason.contains("invalid non-klass dependency")) {
            builder.reason("non_klass_dep");
        } else {
            builder.reason(reason);
        }
        parser.consumePreamble();
    }

    @Override
    protected final CompileFailed fromMatch(ZingCompileEventBuilder builder) {
        return builder.makeFailed();
    }
}

