/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.codeprofile.CodeProfileId;
import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.zing.profilelog.CompileOptions;
import com.azul.zing.profilelog.ProfileLogProcessor;
import com.azul.zing.profilelog.ProfiledTier1Compilation;
import com.azul.zing.profilelog.ProfiledTier1Install;
import com.azul.zing.profilelog.ProfiledTier2Compilation;
import com.azul.zing.profilelog.ProfiledTier2Install;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;

public class CompilationModelBuilder
extends ProfileLogProcessor.Base {
    private final Map<CompilationId, CompilationBuilder> store;

    public CompilationModelBuilder(Map<CompilationId, CompilationBuilder> store) {
        this.store = Objects.requireNonNull(store, "store");
    }

    @Override
    public void process(ProfiledTier1Compilation tier1Comp) {
        CompilationBuilder builder = this.getOrAddCompilationBuilder(tier1Comp.compileId);
        builder.setTier(CompilationTier.TIER_1);
        builder.setMethodId(tier1Comp.methodId);
        this.setCompileOptions(builder, tier1Comp.compileOptions);
        builder.getMutableLoadedKlasses().addAll(tier1Comp.loadedClassIds);
        builder.getMutableLinkedKlasses().addAll(tier1Comp.linkedClassIds);
        builder.getMutableHierarchyKlasses().addAll(tier1Comp.hierarchyClassIds);
    }

    @Override
    public void process(ProfiledTier2Compilation tier2Comp) {
        CompilationBuilder builder = this.getOrAddCompilationBuilder(tier2Comp.compileId);
        builder.setTier(CompilationTier.TIER_2);
        builder.setMethodId(tier2Comp.methodId);
        this.setCompileOptions(builder, tier2Comp.compileOptions);
        builder.getMutableLoadedKlasses().addAll(tier2Comp.loadedClassIds);
        builder.getMutableLinkedKlasses().addAll(tier2Comp.linkedClassIds);
        builder.getMutableInitializedKlasses().addAll(tier2Comp.initializedClassIds);
        builder.getMutableInlinedMethods().addAll(tier2Comp.inlinedMethodIds);
        builder.getMutableHierarchyKlasses().addAll(tier2Comp.hierarchyClassIds);
        for (int profileRefId : tier2Comp.profileRefIds) {
            builder.addCodeProfile(CodeProfileId.of(profileRefId));
        }
    }

    private void setCompileOptions(CompilationBuilder compilation, CompileOptions options) {
        if (options.osrBci != null) {
            compilation.setOsr(options.osrBci);
        }
        compilation.setTrigger(options.trigger);
        compilation.setStashFlavor(options.stashLookup);
        compilation.setOptLevel(options.optHint);
    }

    @Override
    public void process(ProfiledTier1Install tier1Install) {
        CompilationBuilder compilation = this.getOrAddCompilationBuilder(tier1Install.compileId);
        this.setCompileResult(compilation, tier1Install.success, tier1Install.blobSize);
        if (tier1Install.cpuCompileTimeNs != null) {
            compilation.setCpuTime(Duration.ofNanos(tier1Install.cpuCompileTimeNs));
        }
        if (tier1Install.wallCompileTimeNs != null) {
            compilation.setWallTime(Duration.ofNanos(tier1Install.wallCompileTimeNs));
        }
        if (tier1Install.waitTimeNs != null) {
            compilation.setWaitTime(Duration.ofNanos(tier1Install.waitTimeNs));
        }
    }

    @Override
    public void process(ProfiledTier2Install tier2Install) {
        CompilationBuilder compilation = this.getOrAddCompilationBuilder(tier2Install.compileId);
        this.setCompileResult(compilation, tier2Install.success, tier2Install.blobSize);
        compilation.setCpuTime(Duration.ofNanos(tier2Install.cpuCompileTimeNs));
        if (tier2Install.wallCompileTimeNs != null) {
            compilation.setWallTime(Duration.ofNanos(tier2Install.wallCompileTimeNs));
        }
        if (tier2Install.waitTimeNs != null) {
            compilation.setWaitTime(Duration.ofNanos(tier2Install.waitTimeNs));
        }
    }

    private void setCompileResult(CompilationBuilder compilation, boolean success, long blobSize) {
        if (success) {
            compilation.setSuccessfulResult(blobSize);
        } else {
            compilation.setFailure("failure");
        }
    }

    private CompilationBuilder getOrAddCompilationBuilder(CompilationId id) {
        return this.store.computeIfAbsent(id, CompilationBuilder::new);
    }
}

