/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.text.GulpText;
import com.azul.jvm.codeprofile.KlassHistogram;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.method.ByteCodeIndex;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;
import com.azul.zing.profilelog.internals.ProfiledInvokeLineMatcher;
import com.azul.zing.profilelog.internals.ProfiledTypeCheckLineMatcher;
import java.util.List;

public abstract class ProfiledInstruction {
    public final PersistentMethodId methodId;
    public final CompilationId compileId;
    public final Long profileId;
    public final ByteCodeIndex bci;

    ProfiledInstruction(long methodId, int compileId, int bci) {
        this.methodId = PersistentMethodId.of(methodId);
        this.compileId = CompilationId.of(compileId);
        this.profileId = null;
        this.bci = ByteCodeIndex.of(bci);
    }

    ProfiledInstruction(long profileId, int bci) {
        this.methodId = null;
        this.compileId = null;
        this.profileId = profileId;
        this.bci = ByteCodeIndex.of(bci);
    }

    public abstract boolean isEmpty();

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean verbose) {
        return this.headerString(verbose) + this.toStringCore();
    }

    public String headerString(boolean verbose) {
        if (verbose) {
            String profileRef = this.profileId != null ? this.profileId.toString() : this.methodId + " " + this.compileId;
            return this.getClass().getSimpleName() + ": " + profileRef + " @ " + this.bci + " ";
        }
        return this.getClass().getSimpleName() + " @ " + this.bci + " ";
    }

    public abstract String toStringCore();

    @GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
    @ProfileRecord(value="Switch")
    public static class Switch
    extends ProfiledInstruction {
        public final int numCases;
        public final List<Integer> caseCounters;
        public final int defaultCaseCounter;

        @ProfileVersion(value=43)
        public Switch(long profileId, int bci, int numCases, List<Integer> caseCounters, int defaultCaseCounter) {
            super(profileId, bci);
            this.numCases = numCases;
            this.caseCounters = caseCounters;
            this.defaultCaseCounter = defaultCaseCounter;
        }

        @Override
        public final boolean isEmpty() {
            return this.numCases == 0;
        }

        @Override
        public String toStringCore() {
            StringBuilder builder = new StringBuilder();
            builder.append(" numCases: ").append(this.numCases);
            builder.append(" caseCounters: ").append(this.caseCounters);
            builder.append(" defaultCaseCounter: ").append(this.defaultCaseCounter);
            return builder.toString();
        }
    }

    @GulpText.LineMatcher(value=ProfiledTypeCheckLineMatcher.class)
    @ProfileRecord(value="TypeCheck")
    public static class TypeCheck
    extends ProfiledInstruction {
        public final int siteCount;
        public final int failCount;
        public final int overflowCount;
        public final KlassHistogram klassHistogram;

        @ProfileVersion(value=1)
        public TypeCheck(long methodId, int compileId, int bci, int siteCount, int failCount, int overflowCount, KlassHistogram klassHistogram) {
            super(methodId, compileId, bci);
            this.siteCount = siteCount;
            this.failCount = failCount;
            this.overflowCount = overflowCount;
            this.klassHistogram = klassHistogram;
        }

        @ProfileVersion(value=26)
        public TypeCheck(long profileId, int bci, int siteCount, int failCount, int overflowCount, KlassHistogram klassHistogram) {
            super(profileId, bci);
            this.siteCount = siteCount;
            this.failCount = failCount;
            this.overflowCount = overflowCount;
            this.klassHistogram = klassHistogram;
        }

        @Override
        public final boolean isEmpty() {
            return this.siteCount == 0;
        }

        @Override
        public String toStringCore() {
            StringBuilder builder = new StringBuilder();
            builder.append(" count: ").append(this.siteCount);
            builder.append(" fail: ").append(this.failCount);
            builder.append(" overflow: ").append(this.overflowCount);
            builder.append(" histo: {");
            this.klassHistogram.entries().forEach(e -> builder.append(e.klassId()).append('=').append(e.count()).append(", "));
            builder.append('}');
            return builder.toString();
        }
    }

    @GulpText.LineMatcher(value=ProfiledInvokeLineMatcher.class)
    @ProfileRecord(value="Invoke")
    public static class Invoke
    extends ProfiledInstruction {
        public final int siteCount;
        public final int abruptExitCount;
        public final int overflowCount;
        public final KlassHistogram klassHistogram;
        public final Long nestedProfileId;

        @ProfileVersion(value=1)
        public Invoke(long methodId, int compileId, int bci, int siteCount, int overflowCount, KlassHistogram klassHistogram) {
            super(methodId, compileId, bci);
            this.siteCount = siteCount;
            this.abruptExitCount = 0;
            this.overflowCount = overflowCount;
            this.klassHistogram = klassHistogram;
            this.nestedProfileId = null;
        }

        @ProfileVersion(value=26)
        public Invoke(long profileId, int bci, int siteCount, int overflowCount, KlassHistogram klassHistogram, Long nestedProfileId) {
            super(profileId, bci);
            this.siteCount = siteCount;
            this.abruptExitCount = 0;
            this.overflowCount = overflowCount;
            this.klassHistogram = klassHistogram;
            this.nestedProfileId = nestedProfileId;
        }

        @ProfileVersion(value=41)
        public Invoke(long profileId, int bci, int siteCount, int abruptExitCount, int overflowCount, KlassHistogram klassHistogram, Long nestedProfileId) {
            super(profileId, bci);
            this.siteCount = siteCount;
            this.abruptExitCount = abruptExitCount;
            this.overflowCount = overflowCount;
            this.klassHistogram = klassHistogram;
            this.nestedProfileId = nestedProfileId;
        }

        @Override
        public final boolean isEmpty() {
            return this.siteCount == 0;
        }

        @Override
        public String toStringCore() {
            StringBuilder builder = new StringBuilder();
            builder.append(" count: ").append(this.siteCount);
            builder.append(" abruptExit: ").append(this.abruptExitCount);
            builder.append(" overflow: ").append(this.overflowCount);
            builder.append(" histo: {");
            this.klassHistogram.entries().forEach(e -> builder.append(e.klassId()).append('=').append(e.count()).append(", "));
            builder.append('}');
            return builder.toString();
        }
    }

    @GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
    @ProfileRecord(value="Null")
    public static class Null
    extends ProfiledInstruction {
        public final int nullCount;
        public final boolean sawNull;
        public final boolean fail;
        public final boolean rangeCheck;
        public final boolean rangeCheckWide;
        public final boolean monoFail;
        public final boolean biFail;
        public final boolean triFail;

        public Null(long methodId, int compileId, int bci) {
            this(methodId, compileId, bci, 0, false, false, false, false, false, false, false);
        }

        @ProfileVersion(value=6)
        public Null(long methodId, int compileId, int bci, int nullCount, boolean sawNull, boolean fail, boolean rangeCheck, boolean rangeCheckWide, boolean monoFail, boolean biFail, boolean triFail) {
            super(methodId, compileId, bci);
            this.nullCount = nullCount;
            this.sawNull = sawNull;
            this.fail = fail;
            this.rangeCheck = rangeCheck;
            this.rangeCheckWide = rangeCheckWide;
            this.monoFail = monoFail;
            this.biFail = biFail;
            this.triFail = triFail;
        }

        @ProfileVersion(value=26)
        public Null(long profileId, int bci, int nullCount, boolean sawNull, boolean fail, boolean rangeCheck, boolean rangeCheckWide, boolean monoFail, boolean biFail, boolean triFail) {
            super(profileId, bci);
            this.nullCount = nullCount;
            this.sawNull = sawNull;
            this.fail = fail;
            this.rangeCheck = rangeCheck;
            this.rangeCheckWide = rangeCheckWide;
            this.monoFail = monoFail;
            this.biFail = biFail;
            this.triFail = triFail;
        }

        @Override
        public boolean isEmpty() {
            return this.nullCount == 0 && !this.hasBitSet();
        }

        public boolean hasBitSet() {
            return this.sawNull || this.fail || this.rangeCheck || this.rangeCheckWide || this.monoFail || this.biFail || this.triFail;
        }

        @Override
        public String toStringCore() {
            StringBuilder builder = new StringBuilder();
            builder.append("count: ").append(this.nullCount).append(" ");
            builder.append("flags: {");
            if (this.sawNull) {
                builder.append("null, ");
            }
            if (this.fail) {
                builder.append("fail, ");
            }
            if (this.rangeCheck) {
                builder.append("rangeCheck, ");
            }
            if (this.rangeCheckWide) {
                builder.append("rangeCheckWide, ");
            }
            if (this.monoFail) {
                builder.append("monoFail, ");
            }
            if (this.biFail) {
                builder.append("biFail, ");
            }
            if (this.triFail) {
                builder.append("triFail, ");
            }
            builder.append('}');
            return builder.toString();
        }
    }

    @GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
    @ProfileRecord(value="Jump")
    public static final class Jump
    extends ProfiledInstruction {
        public final int taken;

        @ProfileVersion(value=1)
        public Jump(long methodId, int compileId, int bci, int taken) {
            super(methodId, compileId, bci);
            this.taken = taken;
        }

        @ProfileVersion(value=26)
        public Jump(long profileId, int bci, int taken) {
            super(profileId, bci);
            this.taken = taken;
        }

        @Override
        public final boolean isEmpty() {
            return this.taken == 0;
        }

        @Override
        public final String toStringCore() {
            return "taken: " + this.taken;
        }
    }

    @GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
    @ProfileRecord(value="Branch")
    public static final class Branch
    extends ProfiledInstruction {
        public final int taken;
        public final int notTaken;

        @ProfileVersion(value=1)
        public Branch(long methodId, int compileId, int bci, int taken, int notTaken) {
            super(methodId, compileId, bci);
            this.taken = taken;
            this.notTaken = notTaken;
        }

        @ProfileVersion(value=26)
        public Branch(long profileId, int bci, int taken, int notTaken) {
            super(profileId, bci);
            this.taken = taken;
            this.notTaken = notTaken;
        }

        @Override
        public final boolean isEmpty() {
            return this.taken == 0 && this.notTaken == 0;
        }

        @Override
        public final String toStringCore() {
            return "taken: " + this.taken + " notTaken: " + this.notTaken;
        }
    }
}

