/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.text.GulpText;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;
import java.util.Objects;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="Method")
public final class ProfiledMethod {
    public final PersistentMethodId id;
    public final PersistentKlassId classId;
    public final String shortName;
    public final String sig;
    public final int size;

    public ProfiledMethod(long id, int classId, String name, String sig, int size) {
        this.id = PersistentMethodId.of(id);
        this.classId = PersistentKlassId.of(classId);
        this.shortName = name;
        this.sig = sig;
        this.size = size;
    }

    public final int hashCode() {
        return Objects.hash(this.classId, this.shortName, this.sig);
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ProfiledMethod)) {
            return false;
        }
        ProfiledMethod thatMethod = (ProfiledMethod)that;
        return Objects.equals(this.classId, thatMethod.classId) && this.shortName.equals(thatMethod.shortName) && this.sig.equals(thatMethod.sig);
    }

    public String toString() {
        return "Method: " + this.id + " class:" + this.classId + " " + this.shortName + " " + this.sig + " " + this.size;
    }
}

