/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.text.GulpText;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="MethodUniqueness")
public final class ProfiledMethodUniqueness {
    public final PersistentKlassId callerClassId;
    public final PersistentKlassId calleeHolderClassId;
    public final PersistentKlassId receiverClassId;
    public final long methodId;
    public final boolean isMonomorphic;

    @ProfileVersion(value=7)
    public ProfiledMethodUniqueness(int callerClassId, int calleeHolderClassId, int receiverClassId, long methodId, boolean isMonomorphic) {
        this.callerClassId = PersistentKlassId.of(callerClassId);
        this.calleeHolderClassId = PersistentKlassId.of(calleeHolderClassId);
        this.receiverClassId = PersistentKlassId.of(receiverClassId);
        this.methodId = methodId;
        this.isMonomorphic = isMonomorphic;
    }

    @ProfileVersion(value=50)
    public ProfiledMethodUniqueness(int receiverClassId, long methodId, boolean isMonomorphic) {
        this.callerClassId = PersistentKlassId.INVALID;
        this.calleeHolderClassId = PersistentKlassId.INVALID;
        this.receiverClassId = PersistentKlassId.of(receiverClassId);
        this.methodId = methodId;
        this.isMonomorphic = isMonomorphic;
    }

    public final String toString() {
        return "MethodUniqueness:  callerClass: " + this.callerClassId + " holderClass: " + this.calleeHolderClassId + " receiverClass: " + this.receiverClassId + " method: " + this.methodId + " monomorphic?: " + this.isMonomorphic;
    }
}

