/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.deopt.DeoptAction;
import com.azul.jvm.deopt.DeoptReason;
import com.azul.jvm.deopt.StackFrameBuilder;
import com.azul.jvm.deopt.UncommonTrapBuilder;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.time.EpochTime;
import com.azul.jvm.time.VmTime;
import com.azul.zing.profilelog.ProfileLogProcessor;
import com.azul.zing.profilelog.ProfileVmStart;
import com.azul.zing.profilelog.ProfiledDeoptAction;
import com.azul.zing.profilelog.ProfiledDeoptReason;
import com.azul.zing.profilelog.ProfiledUncommonTrap;
import com.azul.zing.profilelog.ProfiledUncommonTrapEnd;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UncommonTrapModelBuilder
extends ProfileLogProcessor.Base {
    private final Map<UncommonTrapId, UncommonTrapBuilder> store;
    private final Map<Integer, String> reasons;
    private final Map<Integer, DeoptAction> actions;
    private EpochTime startTime;

    public UncommonTrapModelBuilder(Map<UncommonTrapId, UncommonTrapBuilder> store) {
        this.store = Objects.requireNonNull(store, "store");
        this.reasons = new HashMap<Integer, String>();
        this.actions = new HashMap<Integer, DeoptAction>();
    }

    @Override
    public void process(ProfileVmStart vmStart) {
        this.startTime = vmStart.epochTime;
    }

    @Override
    public void process(ProfiledDeoptReason deoptReason) {
        this.reasons.put(deoptReason.id, deoptReason.name);
    }

    @Override
    public void process(ProfiledDeoptAction deoptAction) {
        this.actions.put(deoptAction.id, DeoptAction.of(deoptAction.name));
    }

    @Override
    public void process(ProfiledUncommonTrap uncommonTrap) {
        UncommonTrapBuilder builder = this.getOrAddUncommonTrapBuilder(uncommonTrap.id);
        builder.setCompilationId(uncommonTrap.compileId);
        builder.setThreadId(uncommonTrap.threadId);
        String deoptReason = this.reasons.get(uncommonTrap.reasonId);
        if (deoptReason != null) {
            builder.setReasonStr(deoptReason);
            builder.setReason(DeoptReason.fromVmNameOrUnknown(deoptReason));
        }
        if (this.startTime != null) {
            builder.setTime(VmTime.compute(this.startTime, uncommonTrap.epochTime));
        }
    }

    @Override
    public void process(ProfiledUncommonTrapEnd uncommonTrapEnd) {
        UncommonTrapBuilder builder = this.getOrAddUncommonTrapBuilder(uncommonTrapEnd.id);
        builder.setAction(this.actions.get(uncommonTrapEnd.actionId));
        UncommonTrapModelBuilder.mergeStacks(builder.getMutableFrameRepacks(), uncommonTrapEnd.frameRepacks);
    }

    private static void mergeStacks(List<StackFrameBuilder> currentStack, List<ProfiledUncommonTrapEnd.Frame> stackFromLog) {
        int i;
        int commonFrames = Math.min(currentStack.size(), stackFromLog.size());
        for (i = 0; i < commonFrames; ++i) {
            StackFrameBuilder currentFrame = currentStack.get(i);
            ProfiledUncommonTrapEnd.Frame frameFromLog = stackFromLog.get(i);
            if (currentFrame.methodId() == null) {
                currentFrame.setMethodId(frameFromLog.methodId);
            }
            if (currentFrame.bci() == null) {
                currentFrame.setBci(frameFromLog.bci);
            }
            if (currentFrame.opcode() != null) continue;
            currentFrame.setOpcode(frameFromLog.opcode);
        }
        for (i = commonFrames; i < stackFromLog.size(); ++i) {
            ProfiledUncommonTrapEnd.Frame fromLog = stackFromLog.get(i);
            currentStack.add(new StackFrameBuilder().setMethodId(fromLog.methodId).setBci(fromLog.bci).setOpcode(fromLog.opcode));
        }
    }

    private UncommonTrapBuilder getOrAddUncommonTrapBuilder(UncommonTrapId id) {
        return this.store.computeIfAbsent(id, UncommonTrapBuilder::new);
    }
}

