/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog.internals;

import com.azul.gulp.Emitter;
import com.azul.gulp.Gulp;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.jvm.klass.KlassKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderType;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.profilelog.ProfileHeader;
import com.azul.zing.profilelog.ProfileRecord;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ProfileLineMatcher<T>
implements LineMatcher<T> {
    @Gulp.Capture
    public ProfileHeader version;
    private final String prefix;

    ProfileLineMatcher(Class<?> dataClass) {
        this(ProfileLineMatcher.getRecordId(dataClass));
    }

    ProfileLineMatcher(String recordId) {
        this.prefix = recordId;
    }

    static String getRecordId(Class<?> dataClass) {
        return dataClass.getAnnotation(ProfileRecord.class).value();
    }

    @Override
    public void process(Line line, Emitter<T> emitter) throws Exception {
        if (line.startsWith(this.prefix + " ") || line.equals(this.prefix)) {
            InputBuffer buffer = new InputBuffer(line);
            buffer.readIdentifier();
            this.process(this.version, buffer, emitter);
        }
    }

    protected abstract void process(ProfileHeader var1, InputBuffer var2, Emitter<T> var3) throws Exception;

    public static final class InputBuffer {
        private final Line line;
        private final PushbackReader reader;

        InputBuffer(Line line) {
            this.line = line;
            this.reader = new PushbackReader(new StringReader(line.contents), 1);
        }

        public final boolean isEol() {
            int ch = 0;
            ch = this.read();
            while (ch != -1 && Character.isWhitespace(ch)) {
                ch = this.read();
            }
            if (ch == -1) {
                return true;
            }
            try {
                this.reader.unread(ch);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return false;
        }

        public final String readIdentifier() {
            StringBuilder builder = new StringBuilder(80);
            int ch = this.read();
            while (ch != -1) {
                if (Character.isWhitespace(ch)) {
                    return builder.toString();
                }
                builder.append((char)ch);
                ch = this.read();
            }
            return builder.toString();
        }

        public final KlassLoaderType readClassLoaderType() {
            return KlassLoaderType.fromProfileLog(this.readIdentifier());
        }

        public final KlassKind readClassKind() {
            return KlassKind.fromProfileLog(this.readIdentifier());
        }

        public final int readCount() {
            return this.readInt();
        }

        public final int readInt() {
            return Integer.parseInt(this.readIdentifier(), 10);
        }

        public final int readBci() {
            String str = this.readIdentifier();
            try {
                return Integer.parseInt(str, 10);
            }
            catch (NumberFormatException e) {
                switch (str) {
                    case "4294967294": {
                        return -1;
                    }
                }
                throw e;
            }
        }

        public final Integer readOptionalInteger() {
            if (this.isEol()) {
                return null;
            }
            return this.readInt();
        }

        public final boolean readBoolean() {
            return this.readIdentifier().equals("1");
        }

        public final long readLong() {
            return Long.parseLong(this.readIdentifier(), 10);
        }

        public final Long readOptionalLong() {
            return this.isEol() ? null : Long.valueOf(this.readLong());
        }

        public void readListStart() {
            this.chomp();
            this.assertChar('{');
            this.chomp();
        }

        public boolean isListEnd() {
            this.chomp();
            return this.peek() == 125;
        }

        public void readListEnd() {
            this.chomp();
            this.assertChar('}');
            this.chomp();
        }

        public final List<Integer> readIntList() {
            ArrayList<Integer> ints = new ArrayList<Integer>();
            this.readListStart();
            while (!this.isListEnd()) {
                ints.add(this.readInt());
            }
            this.readListEnd();
            return Collections.unmodifiableList(ints);
        }

        public final List<Long> readLongList() {
            ArrayList<Long> longs = new ArrayList<Long>();
            this.readListStart();
            while (!this.isListEnd()) {
                longs.add(this.readLong());
            }
            this.readListEnd();
            return Collections.unmodifiableList(longs);
        }

        public List<PersistentKlassId> readPersistentKlassIdList() {
            ArrayList<PersistentKlassId> ids = new ArrayList<PersistentKlassId>();
            this.readListStart();
            while (!this.isListEnd()) {
                ids.add(PersistentKlassId.of(this.readInt()));
            }
            this.readListEnd();
            return ids;
        }

        public List<PersistentMethodId> readPersistentMethodIdList() {
            ArrayList<PersistentMethodId> ids = new ArrayList<PersistentMethodId>();
            this.readListStart();
            while (!this.isListEnd()) {
                ids.add(PersistentMethodId.of(this.readLong()));
            }
            this.readListEnd();
            return ids;
        }

        private int read() {
            try {
                return this.reader.read();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private int peek() {
            try {
                int ch = this.reader.read();
                this.reader.unread(ch);
                return ch;
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }

        private char readChar() {
            int ch = this.read();
            return ch == -1 ? (char)'\u0000' : (char)ch;
        }

        private char peekChar() {
            int ch = this.peek();
            return ch == -1 ? (char)'\u0000' : (char)ch;
        }

        private void assertChar(char ch) {
            try {
                this.assertCharImpl(ch);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private void assertCharImpl(char ch) throws IOException {
            if (this.readChar() != ch) {
                throw new IOException("Unhandled line " + this.line.num + ": Expected char: " + ch);
            }
        }

        private void chomp() {
            try {
                int cur = this.reader.read();
                while (cur != -1) {
                    char curCh = (char)cur;
                    if (!Character.isWhitespace(curCh)) {
                        this.reader.unread(curCh);
                        return;
                    }
                    cur = this.reader.read();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public final String toString() {
            return this.line.toString();
        }
    }
}

