/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.zvrobot.tickprofile.internals;

import com.azul.xml.sax.Characters;
import com.azul.xml.sax.stack.Tag;
import com.azul.zing.zvrobot.tickprofile.CodeRef;
import com.azul.zing.zvrobot.tickprofile.internals.CodeBlobRefImpl;
import com.azul.zing.zvrobot.tickprofile.internals.CodeRefHandler;
import com.azul.zing.zvrobot.tickprofile.internals.LeafTagHandler;

final class CodeBlobRefHandler
extends CodeRefHandler {
    CodeBlobRefImpl blobRef = new CodeBlobRefImpl();

    CodeBlobRefHandler() {
    }

    @Override
    final CodeRef result() {
        return this.blobRef;
    }

    @Override
    final LeafTagHandler.CharactersHandler getCharactersHandler(Tag tag) throws Exception {
        switch (tag.qName) {
            case "name": {
                return chars -> {
                    this.blobRef.name = chars.toString();
                };
            }
            case "signature": {
                return chars -> {
                    this.blobRef.sig = chars.toString();
                };
            }
            case "id": {
                return chars -> {
                    this.blobRef.id = chars.toString();
                };
            }
            case "type": {
                return chars -> {
                    this.blobRef.type = CodeBlobRefHandler.parseType(chars);
                };
            }
            case "osr_entry_bci": {
                return chars -> {
                    this.blobRef.osrEntryBci = chars.parseInt();
                };
            }
        }
        return null;
    }

    private static CodeRef.RefType parseType(Characters chars) {
        switch (chars.toString()) {
            case "c1": {
                return CodeRef.RefType.C1_NORMAL;
            }
            case "c2": {
                return CodeRef.RefType.C2_NORMAL;
            }
            case "native": {
                return CodeRef.RefType.NATIVE;
            }
            case "vtablestub": {
                return CodeRef.RefType.VTABLE_STUB;
            }
            case "c2i_adapter": {
                return CodeRef.RefType.C2I_ADAPTER;
            }
            case "methodstub": {
                return CodeRef.RefType.METHOD_STUB;
            }
            case "runtime_stubs": {
                return CodeRef.RefType.RUNTIME_STUBS;
            }
        }
        throw new IllegalArgumentException(chars.toString());
    }
}

