/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.zvrobot.tickprofile.internals;

import com.azul.xml.sax.Characters;
import com.azul.xml.sax.stack.DefaultTagHandler;
import com.azul.xml.sax.stack.Tag;
import com.azul.xml.sax.stack.TagHandler;
import com.azul.zing.zvrobot.tickprofile.ProcessInfo;
import com.azul.zing.zvrobot.tickprofile.internals.LeafTagHandler;
import com.azul.zing.zvrobot.tickprofile.internals.ProcessInfoImpl;

final class ProcessTagHandler
extends DefaultTagHandler {
    private final ProcessInfoImpl processInfo = new ProcessInfoImpl();

    ProcessTagHandler() {
    }

    @Override
    public TagHandler getChildTagHandler(Tag tag) throws Exception {
        LeafTagHandler.CharactersHandler charsProcessor = this.getChildCharactersProcessor(tag);
        if (charsProcessor == null) {
            return null;
        }
        return new LeafTagHandler(charsProcessor);
    }

    public final ProcessInfo result() {
        return this.processInfo;
    }

    protected final LeafTagHandler.CharactersHandler getChildCharactersProcessor(Tag tag) throws Exception {
        switch (tag.qName) {
            case "user": {
                return chars -> {
                    this.processInfo.user = chars.toString();
                };
            }
            case "host": {
                return chars -> {
                    this.processInfo.host = chars.toString();
                };
            }
            case "pid": {
                return chars -> {
                    this.processInfo.pid = chars.parseInt();
                };
            }
            case "uptime": {
                return chars -> {
                    this.processInfo.uptimeSecs = ProcessTagHandler.parseUptime(chars);
                };
            }
        }
        return null;
    }

    private static int parseUptime(Characters characters) {
        String timeStr = characters.toString();
        String[] parts = timeStr.split(":");
        if (parts.length != 3) {
            throw new IllegalStateException(timeStr);
        }
        int hourPart = Integer.parseInt(parts[0], 10);
        int minPart = Integer.parseInt(parts[1], 10);
        int secPart = Integer.parseInt(parts[2], 10);
        int totalHours = hourPart;
        int totalMins = 60 * totalHours + minPart;
        int totalSecs = 60 * totalMins + secPart;
        return totalSecs;
    }
}

