/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.online.statistics;

import com.microsoft.gctoolkit.online.statistics.NotEnoughSampleException;
import com.microsoft.gctoolkit.online.statistics.OnlineMeanCalculator;
import com.microsoft.gctoolkit.online.statistics.OnlineStatisticsCalculator;

public class WelfordVarianceCalculator
implements OnlineStatisticsCalculator {
    private int numSamples = 0;
    private double m2 = 0.0;
    private final OnlineMeanCalculator onlineMeanCalculator = new OnlineMeanCalculator();

    @Override
    public void update(double sampleValue) {
        double oldMean = this.onlineMeanCalculator.getValue();
        this.onlineMeanCalculator.update(sampleValue);
        ++this.numSamples;
        double newMean = this.onlineMeanCalculator.getValue();
        this.m2 += (sampleValue - oldMean) * (sampleValue - newMean);
    }

    @Override
    public double getValue() throws NotEnoughSampleException {
        if (this.numSamples < 2) {
            throw new NotEnoughSampleException("Variance requires at least 2 samples.");
        }
        return this.m2 / (double)(this.numSamples - 1);
    }
}

