/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.MetaspaceRecord;
import com.microsoft.gctoolkit.event.jvm.PermGenSummary;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.DataSourceParser;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.SharedPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GCLogParser
implements DataSourceParser,
SharedPatterns {
    private static final Logger LOGGER = Logger.getLogger(GCLogParser.class.getName());
    public static final String END_OF_DATA_SENTINEL = "END_OF_DATA_SENTINEL";
    public static final GCParseRule GCID_COUNTER = new GCParseRule("GCID_COUNTER", " GC\\((\\d+)\\) ");
    private JVMEventChannel consumer;
    protected Diary diary;
    private DateTimeStamp clock = new DateTimeStamp(DateTimeStamp.EPOC, 0.0);
    private double lastDuration = 0.0;

    @Override
    public void diary(Diary diary) {
        this.diary = diary;
        this.clock = diary.getTimeOfFirstEvent();
    }

    public DateTimeStamp getClock() {
        return this.clock;
    }

    public void setClock(DateTimeStamp newValue) {
        this.clock = newValue;
    }

    public abstract String getName();

    protected abstract void process(String var1);

    abstract void advanceClock(String var1);

    protected final void advanceClock(DateTimeStamp now) {
        if (now == null) {
            return;
        }
        if (now.before(this.getClock())) {
            LOGGER.log(Level.WARNING, "Log File may be Corrupted: Time traveled backwards from {0} to {1}", new Object[]{this.getClock().toString(), now.toString()});
        }
        this.setClock(now);
    }

    public void publish(ChannelName channel, JVMEvent event) {
        this.lastDuration = event.getDuration();
        this.consumer.publish(channel, event);
    }

    @Override
    public void receive(String trace) {
        if (!trace.equals(END_OF_DATA_SENTINEL)) {
            this.advanceClock(trace);
        } else {
            this.advanceClock(this.getClock().add(this.lastDuration));
        }
        this.process(trace);
    }

    boolean isPreJDK17040() {
        return this.diary.isPre70_40();
    }

    boolean hasPrintGCDetails() {
        return this.diary.isPrintGCDetails();
    }

    MemoryPoolSummary getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(GCLogTrace trace, int offset) {
        return trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(offset);
    }

    MemoryPoolSummary getTotalOccupancyWithTotalHeapSizeSummary(GCLogTrace trace, int offset) {
        return trace.getOccupancyWithMemoryPoolSizeSummary(offset);
    }

    GCLogTrace extractReferenceBlock(String line, GCParseRule rule) {
        return rule.parse(line);
    }

    ReferenceGCSummary extractPrintReferenceGC(String line) {
        ReferenceGCSummary summary = new ReferenceGCSummary();
        GCLogTrace trace = this.extractReferenceBlock(line, SOFT_REFERENCE);
        if (trace != null) {
            summary.addSoftReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(6), trace.getDuration());
        }
        if ((trace = this.extractReferenceBlock(line, WEAK_REFERENCE)) != null) {
            summary.addWeakReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(6), trace.getDuration());
        }
        if ((trace = this.extractReferenceBlock(line, FINAL_REFERENCE)) != null) {
            summary.addFinalReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(6), trace.getDuration());
        }
        if ((trace = this.extractReferenceBlock(line, PHANTOM_REFERENCE)) != null) {
            if (trace.groupNotNull(7)) {
                summary.addPhantomReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(6), trace.getIntegerGroup(7), trace.getDuration());
            } else {
                summary.addPhantomReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(6), trace.getDuration());
            }
        }
        if ((trace = this.extractReferenceBlock(line, JNI_REFERENCE)) != null) {
            if (trace.groupNotNull(6)) {
                summary.addJNIWeakReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(6), trace.getDuration());
            } else {
                summary.addJNIWeakReferences(trace.getDateTimeStamp(), trace.getDuration());
            }
        }
        return summary;
    }

    MemoryPoolSummary extractPermOrMetaspaceRecord(String line) {
        MemoryPoolSummary metaDataPool = null;
        GCLogTrace trace = PERM_SPACE_RECORD.parse(line);
        if (trace != null) {
            String recordType;
            switch (recordType = trace.getGroup(1).trim()) {
                case "CMS Perm": 
                case "PS Perm": 
                case "PSPermGen": 
                case "Perm": {
                    metaDataPool = this.extractPermGenRecord(trace);
                    break;
                }
                case "Metaspace": {
                    metaDataPool = trace.getGroup(2) != null ? new MetaspaceRecord(trace.toKBytes(2), trace.toKBytes(4), trace.toKBytes(6)) : new MetaspaceRecord(trace.toKBytes(4), trace.toKBytes(4), trace.toKBytes(6));
                }
            }
        } else {
            trace = META_SPACE_RECORD.parse(line);
            if (trace != null) {
                int index = trace.getGroup(1) == null ? 1 : 3;
                metaDataPool = new MetaspaceRecord(trace.toKBytes(index), trace.toKBytes(3), trace.toKBytes(5));
            }
        }
        return metaDataPool;
    }

    MemoryPoolSummary extractPermGenRecord(GCLogTrace trace) {
        int index = trace.getGroup(2) == null ? 2 : 4;
        return new PermGenSummary(trace.getLongGroup(index), trace.getLongGroup(4), trace.getLongGroup(6));
    }

    int extractGCID(String line) {
        GCLogTrace trace = GCID_COUNTER.parse(line);
        return trace != null ? trace.getIntegerGroup(1) : -1;
    }

    CPUSummary extractCPUSummary(String line) {
        GCLogTrace trace = CPU_BREAKDOWN.parse(line);
        if (trace != null) {
            return new CPUSummary(trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3));
        }
        return null;
    }

    @Override
    public void publishTo(JVMEventChannel channel) {
        this.consumer = channel;
    }

    @Override
    public ChannelName channel() {
        return ChannelName.DATA_SOURCE;
    }
}

