/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.parser.vmops.SafepointTrace;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SafepointParseRule {
    private static final ConcurrentMap<SafepointParseRule, AtomicInteger> hits = new ConcurrentHashMap<SafepointParseRule, AtomicInteger>();
    private static final ConcurrentMap<SafepointParseRule, AtomicInteger> misses = new ConcurrentHashMap<SafepointParseRule, AtomicInteger>();
    private static final ConcurrentMap<SafepointParseRule, Throwable> origin = new ConcurrentHashMap<SafepointParseRule, Throwable>();
    private final Pattern pattern;

    public SafepointParseRule(String pattern) {
        this.pattern = Pattern.compile(pattern);
        Throwable throwable = new Throwable();
        throwable = throwable.fillInStackTrace();
        origin.put(this, throwable);
    }

    public SafepointTrace parse(String trace) {
        Matcher matcher = this.pattern.matcher(trace);
        if (matcher.find()) {
            this.hits();
            return new SafepointTrace(matcher);
        }
        this.misses();
        return null;
    }

    private void hits() {
        AtomicInteger count = (AtomicInteger)hits.get(this);
        if (count == null) {
            count = new AtomicInteger(0);
            hits.put(this, count);
        }
        count.getAndIncrement();
    }

    private void misses() {
        AtomicInteger count = (AtomicInteger)misses.get(this);
        if (count == null) {
            count = new AtomicInteger(0);
            misses.put(this, count);
        }
        count.getAndIncrement();
    }

    public static ConcurrentMap<SafepointParseRule, AtomicInteger> getHits() {
        return hits;
    }

    public static ConcurrentMap<SafepointParseRule, AtomicInteger> getMisses() {
        return misses;
    }

    public static ConcurrentMap<SafepointParseRule, Throwable> getOrigin() {
        return origin;
    }

    public String toString() {
        return this.pattern.toString();
    }
}

