/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GCEvent;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.zgc.FullZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MajorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MinorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.OccupancySummary;
import com.microsoft.gctoolkit.event.zgc.ZGCAllocatedSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCCollectionType;
import com.microsoft.gctoolkit.event.zgc.ZGCCompactedSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCGarbageSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCHeapCapacitySummary;
import com.microsoft.gctoolkit.event.zgc.ZGCLiveSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCMarkSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCMemoryPoolSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCMemorySummary;
import com.microsoft.gctoolkit.event.zgc.ZGCMetaspaceSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCNMethodSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCPageAgeSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCPageSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCPhase;
import com.microsoft.gctoolkit.event.zgc.ZGCPromotedSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCReclaimSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCReferenceSummary;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.parser.unified.ZGCPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZGCParser
extends UnifiedGCLogParser
implements ZGCPatterns {
    private static final Logger LOGGER = Logger.getLogger(ZGCParser.class.getName());
    private final boolean debugging = Boolean.getBoolean("microsoft.debug");
    private final boolean develop = Boolean.getBoolean("microsoft.develop");
    private ZForwardReference forwardReference;
    private final long[] markStart = new long[3];
    private final long[] markEnd = new long[3];
    private final long[] relocateStart = new long[3];
    private final long[] relocateEnd = new long[3];
    private final long[] heapCapacity = new long[3];
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new MRUQueue();
    private boolean oldGenHeapStats = false;
    private boolean youngGenHeapStats = false;

    public ZGCParser() {
        this.parseRules.put(CYCLE_START, this::cycleStart);
        this.parseRules.put(PAUSE_PHASE, this::pausePhase);
        this.parseRules.put(CONCURRENT_PHASE, this::concurrentPhase);
        this.parseRules.put(LOAD, this::load);
        this.parseRules.put(MMU, this::mmu);
        this.parseRules.put(MARK_SUMMARY, this::markSummary);
        this.parseRules.put(RELOCATION_SUMMARY, this::relocationSummary);
        this.parseRules.put(NMETHODS, this::nMethods);
        this.parseRules.put(METASPACE, this::metaspace);
        this.parseRules.put(REFERENCE_PROCESSING, this::referenceProcessing);
        this.parseRules.put(CAPACITY, this::capacity);
        this.parseRules.put(MEMORY_TABLE_ENTRY_SIZE, this::sizeEntry);
        this.parseRules.put(MEMORY_TABLE_ENTRY_OCCUPANCY, this::occupancyEntry);
        this.parseRules.put(MEMORY_SUMMARY, this::memorySummary);
        this.parseRules.put(END_OF_FILE, this::endOfFile);
        this.parseRules.put(MEMORY_TABLE_ENTRY_RECLAIMED_PROMOTED, this::reclaimedPromoted);
        this.parseRules.put(MEMORY_TABLE_ENTRY_COMPACTED, this::compacted);
        this.parseRules.put(LOAD_GEN, this::loadGen);
        this.parseRules.put(REFERENCE_PROCESSING_GEN, this::referenceProcessingGen);
        this.parseRules.put(END_OF_PHASE_SUMMARY_GEN, this::endOfPhaseMemorySummary);
        this.parseRules.put(PAGES_GEN, this::pageSummary);
        this.parseRules.put(FORWARDING_USAGE_GEN, this::forwardingUsage);
        this.parseRules.put(AGE_TABLE_GEN, this::ageTable);
        this.parseRules.put(MARK_OLD_GEN_HEAP_STATS, this::markOldGenHeapStats);
        this.parseRules.put(MARK_YOUNG_GEN_HEAP_STATS, this::markYoungGenHeapStats);
    }

    @Override
    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.ZGC);
    }

    private void markYoungGenHeapStats(GCLogTrace gcLogTrace, String s) {
        this.youngGenHeapStats = true;
        this.oldGenHeapStats = false;
    }

    private void markOldGenHeapStats(GCLogTrace gcLogTrace, String s) {
        this.youngGenHeapStats = false;
        this.oldGenHeapStats = true;
    }

    @Override
    public String getName() {
        return "ZGC Parser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentButUnwantedEntries(line)) {
            return;
        }
        try {
            Optional<AbstractMap.SimpleEntry> optional = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
            if (optional.isPresent()) {
                AbstractMap.SimpleEntry ruleAndTrace = optional.get();
                this.parseRules.get(ruleAndTrace.getKey()).accept((GCLogTrace)ruleAndTrace.getValue(), line);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
        this.log(line);
    }

    private boolean ignoreFrequentButUnwantedEntries(String line) {
        return MEMORY_TABLE_HEADER.parse(line) != null;
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.publish(new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    private ZGCForwardReference getForwardRefForPhase(ZGCPhase zgcPhase) {
        switch (zgcPhase) {
            case FULL: {
                return (ZGCForwardReference)this.forwardReference;
            }
            case MAJOR_YOUNG: {
                return ((ZGCMajorForwardReference)this.forwardReference).getYoungGeneration();
            }
            case MAJOR_OLD: {
                return ((ZGCMajorForwardReference)this.forwardReference).getOldGeneration();
            }
            case MINOR_YOUNG: {
                return ((ZGCMinorForwardReference)this.forwardReference).getYoungGeneration();
            }
        }
        throw new RuntimeException("Unknown phase " + zgcPhase);
    }

    private void cycleStart(GCLogTrace trace, String s) {
        ZGCCollectionType type = ZGCCollectionType.get(trace.getGroup(2));
        switch (type) {
            case FULL: {
                this.forwardReference = new ZGCForwardReference(this.getClock(), trace.getLongGroup(1), trace.gcCause(3, 0), type, ZGCPhase.FULL);
                break;
            }
            case MINOR: {
                this.forwardReference = new ZGCMinorForwardReference(this.getClock(), trace.getLongGroup(1), trace.gcCause(3, 0), type);
                break;
            }
            case MAJOR: {
                this.forwardReference = new ZGCMajorForwardReference(this.getClock(), trace.getLongGroup(1), trace.gcCause(3, 0), type);
            }
        }
    }

    private void pausePhase(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        DateTimeStamp startTime = this.getClock().minus(trace.getDuration() / 1000.0);
        if ("Mark Start".equals(trace.getGroup(2))) {
            ref.setPauseMarkStartDuration(trace.getDuration());
            ref.setPauseMarkStart(startTime);
        }
        if ("Mark Start (Major)".equals(trace.getGroup(2))) {
            ref.setPauseMarkStartDuration(trace.getDuration());
            ref.setPauseMarkStart(startTime);
        } else if ("Mark End".equals(trace.getGroup(2))) {
            ref.setPauseMarkEndDuration(trace.getDuration());
            ref.setPauseMarkEndStart(startTime);
        } else if ("Relocate Start".equals(trace.getGroup(2))) {
            ref.setPauseRelocateStartDuration(trace.getDuration());
            ref.setPauseRelocateStart(startTime);
        } else {
            trace.notYetImplemented();
        }
    }

    private void concurrentPhase(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        DateTimeStamp startTime = this.getClock().minus(trace.getDuration() / 1000.0);
        if ("Mark".equals(trace.getGroup(2))) {
            ref.setConcurrentMarkDuration(trace.getDuration());
            ref.setConcurrentMarkStart(startTime);
        } else if ("Mark Continue".equals(trace.getGroup(2))) {
            ref.setConcurrentMarkContinueDuration(trace.getDuration());
            ref.setConcurrentMarkContinueStart(startTime);
        } else if ("Mark Free".equals(trace.getGroup(2))) {
            ref.setConcurrentMarkFreeDuration(trace.getDuration());
            ref.setConcurrentMarkFreeStart(startTime);
        } else if ("Process Non-Strong References".equals(trace.getGroup(2)) || "Process Non-Strong".equals(trace.getGroup(2))) {
            ref.setConcurrentProcessNonStrongReferencesDuration(trace.getDuration());
            ref.setConcurrentProcessNonStringReferencesStart(startTime);
        } else if ("Reset Relocation Set".equals(trace.getGroup(2))) {
            ref.setConcurrentResetRelocationSetDuration(trace.getDuration());
            ref.setConcurrentResetRelocationSetStart(startTime);
        } else if ("Select Relocation Set".equals(trace.getGroup(2))) {
            ref.setConcurrentSelectRelocationSetDuration(trace.getDuration());
            ref.setConcurrentSelectRelocationSetStart(startTime);
        } else if ("Relocate".equals(trace.getGroup(2))) {
            ref.setConcurrentSelectRelocateStart(startTime);
            ref.setConcurrentSelectRelocateDuration(trace.getDuration());
        } else if ("Remap Roots".equals(trace.getGroup(2))) {
            ref.setConcurrentRemapRootsStart(startTime);
            ref.setConcurrentRemapRootsDuration(trace.getDuration());
        } else if ("Mark Roots".equals(trace.getGroup(2))) {
            ref.setMarkRootsStart(startTime);
            ref.setMarkRootsDuration(trace.getDuration());
        } else if ("Mark Follow".equals(trace.getGroup(2))) {
            ref.setMarkFollowStart(startTime);
            ref.setMarkFollowDuration(trace.getDuration());
        } else if ("Remap Roots Colored".equals(trace.getGroup(2))) {
            ref.setRemapRootsColoredStart(startTime);
            ref.setRemapRootsColoredDuration(trace.getDuration());
        } else if ("Remap Roots Uncolored".equals(trace.getGroup(2))) {
            ref.setRemapRootsUncoloredStart(startTime);
            ref.setRemapRootsUncoloredDuration(trace.getDuration());
        } else if ("Remap Remembered".equals(trace.getGroup(2))) {
            ref.setRemapRememberedStart(startTime);
            ref.setRemapRememberedDuration(trace.getDuration());
        } else {
            trace.notYetImplemented();
        }
    }

    private void pageSummary(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ZGCPageSummary summary = new ZGCPageSummary(trace.getLongGroup(3), trace.getLongGroup(4), trace.getLongGroup(5), trace.toKBytes(6), trace.toKBytes(8), trace.toKBytes(10));
        if ("Small".equals(trace.getGroup(2))) {
            ref.setSmallPageSummary(summary);
        } else if ("Medium".equals(trace.getGroup(2))) {
            ref.setMediumPageSummary(summary);
        } else if ("Large".equals(trace.getGroup(2))) {
            ref.setLargePageSummary(summary);
        }
    }

    private void forwardingUsage(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ref.setForwardingUsage(trace.toKBytes(2));
    }

    private void ageTable(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ZGCPageAgeSummary summary = new ZGCPageAgeSummary(trace.getGroup(2), trace.toKBytes(3), trace.getIntegerGroup(5), trace.toKBytes(6), trace.getIntegerGroup(8), trace.getLongGroup(9), trace.getLongGroup(10), trace.getLongGroup(11), trace.getLongGroup(12), trace.getLongGroup(13), trace.getLongGroup(14));
        ref.addPageAgeSummary(summary);
    }

    private void load(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        double[] load = new double[]{trace.getDoubleGroup(2), trace.getDoubleGroup(3), trace.getDoubleGroup(4)};
        ref.setLoad(load);
    }

    private void loadGen(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        double[] load = new double[]{trace.getDoubleGroup(2), trace.getDoubleGroup(3), trace.getDoubleGroup(4)};
        ref.setLoad(load);
    }

    private void mmu(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        double[] mmu = new double[]{trace.getDoubleGroup(2), trace.getDoubleGroup(3), trace.getDoubleGroup(4), trace.getDoubleGroup(5), trace.getDoubleGroup(6), trace.getDoubleGroup(7)};
        ref.setMMU(mmu);
    }

    private void markSummary(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ref.setMarkSummary(new ZGCMarkSummary(trace.getIntegerGroup(2), trace.getIntegerGroup(3), trace.getIntegerGroup(4), trace.getIntegerGroup(5), trace.getIntegerGroup(6)));
    }

    private void relocationSummary(GCLogTrace trace, String s) {
    }

    private void nMethods(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ZGCNMethodSummary summary = new ZGCNMethodSummary(trace.getLongGroup(2), trace.getLongGroup(3));
        ref.setNMethodSummary(summary);
    }

    private void metaspace(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ZGCMetaspaceSummary summary = new ZGCMetaspaceSummary(trace.toKBytes(2), trace.toKBytes(4), trace.toKBytes(6));
        ref.setMetaspaceSummary(summary);
    }

    private void referenceProcessing(GCLogTrace trace, String s) {
    }

    private void referenceProcessingGen(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ZGCReferenceSummary summary = new ZGCReferenceSummary(trace.getLongGroup(3), trace.getLongGroup(4), trace.getLongGroup(5));
        if ("Soft".equals(trace.getGroup(2))) {
            ref.setSoftRefSummary(summary);
        } else if ("Weak".equals(trace.getGroup(2))) {
            ref.setWeakRefSummary(summary);
        } else if ("Final".equals(trace.getGroup(2))) {
            ref.setFinalRefSummary(summary);
        } else if ("Phantom".equals(trace.getGroup(2))) {
            ref.setPhantomRefSummary(summary);
        }
    }

    private void capacity(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        if ("Min Capacity".equals(trace.getGroup(2))) {
            this.heapCapacity[0] = trace.toKBytes(3);
        } else if ("Max Capacity".equals(trace.getGroup(2))) {
            this.heapCapacity[1] = trace.toKBytes(3);
        } else if ("Soft Max Capacity".equals(trace.getGroup(2))) {
            this.heapCapacity[2] = trace.toKBytes(3);
            ref.setHeapCapacitySummary(new ZGCHeapCapacitySummary(this.heapCapacity[0], this.heapCapacity[1], this.heapCapacity[2]));
        }
    }

    private void captureAtIndex(GCLogTrace trace, int index) {
        this.markStart[index] = trace.toKBytes(3);
        this.markEnd[index] = trace.toKBytes(6);
        this.relocateStart[index] = trace.toKBytes(9);
        this.relocateEnd[index] = trace.toKBytes(12);
    }

    private void sizeEntry(GCLogTrace trace, String s) {
        ZGCPhase phase = trace.getZCollectionPhase();
        ZGCForwardReference ref = this.getForwardRefForPhase(phase);
        if (this.oldGenHeapStats || this.youngGenHeapStats) {
            if ("Used".equals(trace.getGroup(2))) {
                OccupancySummary summary = new OccupancySummary(trace.toKBytes(3), trace.toKBytes(6), trace.toKBytes(9), trace.toKBytes(12));
                ref.setUsed(phase, summary);
            } else {
                trace.notYetImplemented();
            }
            return;
        }
        switch (trace.getGroup(2)) {
            case "Capacity": {
                this.captureAtIndex(trace, 0);
                break;
            }
            case "Free": {
                this.captureAtIndex(trace, 1);
                break;
            }
            case "Used": {
                ref.setMarkStart(new ZGCMemoryPoolSummary(this.markStart[0], this.markStart[1], trace.toKBytes(3)));
                ref.setMarkEnd(new ZGCMemoryPoolSummary(this.markEnd[0], this.markEnd[1], trace.toKBytes(6)));
                ref.setRelocateStart(new ZGCMemoryPoolSummary(this.relocateStart[0], this.relocateStart[1], trace.toKBytes(9)));
                ref.setRelocateEnd(new ZGCMemoryPoolSummary(this.relocateEnd[0], this.relocateEnd[1], trace.toKBytes(12)));
                break;
            }
            default: {
                LOGGER.warning(trace.getGroup(2) + "not recognized, Heap Occupancy/size is is ignored. Please report this with the GC log");
            }
        }
    }

    private void occupancyEntry(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        if ("Live".equals(trace.getGroup(2))) {
            ref.setMarkedLiveSummary(new ZGCLiveSummary(trace.toKBytes(3), trace.toKBytes(6), trace.toKBytes(9)));
        } else if ("Allocated".equals(trace.getGroup(2))) {
            ref.setAllocatedSummary(new ZGCAllocatedSummary(trace.toKBytes(3), trace.toKBytes(6), trace.toKBytes(9)));
        } else if ("Garbage".equals(trace.getGroup(2))) {
            ref.setGarbageSummary(new ZGCGarbageSummary(trace.toKBytes(3), trace.toKBytes(6), trace.toKBytes(9)));
        } else {
            trace.notYetImplemented();
        }
    }

    private void reclaimedPromoted(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        if ("Reclaimed".equals(trace.getGroup(2))) {
            ref.setReclaimSummary(new ZGCReclaimSummary(trace.toKBytes(3), trace.toKBytes(6)));
        } else if ("Promoted".equals(trace.getGroup(2))) {
            ref.setPromotedSummary(new ZGCPromotedSummary(trace.toKBytes(3), trace.toKBytes(6)));
        }
    }

    private void compacted(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        this.oldGenHeapStats = false;
        this.youngGenHeapStats = false;
        ref.setCompactedSummary(new ZGCCompactedSummary(trace.toKBytes(2)));
    }

    private void endOfPhaseMemorySummary(GCLogTrace trace, String s) {
        ZGCForwardReference ref = this.getForwardRefForPhase(trace.getZCollectionPhase());
        ref.setMemorySummary(new ZGCMemorySummary(trace.toKBytes(3), trace.toKBytes(6)));
        if (trace.getGroup(9) != null) {
            ref.setGcDuration(trace.getSeconds(9));
        }
    }

    private void memorySummary(GCLogTrace trace, String s) {
        ZGCCollectionType type = ZGCCollectionType.get(trace.getGroup(1));
        switch (type) {
            case FULL: {
                ((ZGCForwardReference)this.forwardReference).setMemorySummary(new ZGCMemorySummary(trace.toKBytes(3), trace.toKBytes(6)));
                break;
            }
            case MINOR: {
                ((ZGCMinorForwardReference)this.forwardReference).setMemorySummary(new ZGCMemorySummary(trace.toKBytes(3), trace.toKBytes(6)));
                break;
            }
            case MAJOR: {
                ((ZGCMajorForwardReference)this.forwardReference).setMemorySummary(new ZGCMemorySummary(trace.toKBytes(3), trace.toKBytes(6)));
            }
        }
        Arrays.fill(this.markStart, 0L);
        Arrays.fill(this.markEnd, 0L);
        Arrays.fill(this.relocateStart, 0L);
        Arrays.fill(this.relocateEnd, 0L);
        Arrays.fill(this.heapCapacity, 0L);
        this.oldGenHeapStats = false;
        this.youngGenHeapStats = false;
        this.publish();
    }

    private void log(String line) {
        GCToolKit.LOG_DEBUG_MESSAGE(() -> "ZGCHeapParser missed: " + line);
        LOGGER.log(Level.WARNING, "Missed: {0}", line);
    }

    public void logMissedFirstRecordForEvent(String line) {
        LOGGER.log(Level.WARNING, "Missing initial record for: {0}", line);
    }

    public void publish() {
        this.publish(this.forwardReference.getGCEVent(this.getClock()));
    }

    public void publish(JVMEvent event) {
        super.publish(ChannelName.ZGC_PARSER_OUTBOX, event);
        this.forwardReference = null;
    }

    @Override
    public boolean accepts(Diary diary) {
        return diary.isZGC();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }

    private static class ZGCForwardReference
    implements ZForwardReference {
        private final DateTimeStamp startTimeStamp;
        private final GCCause gcCause;
        private final ZGCCollectionType type;
        private final ZGCPhase phase;
        private final long gcId;
        private DateTimeStamp pauseMarkStart;
        private double pauseMarkStartDuration;
        private DateTimeStamp pauseMarkEndStart;
        private double pauseMarkEndDuration;
        private DateTimeStamp pauseRelocateStart;
        private double pauseRelocateStartDuration;
        private DateTimeStamp concurrentMarkStart;
        private double concurrentMarkDuration;
        private double concurrentMarkFreeDuration;
        private DateTimeStamp concurrentMarkFreeStart;
        private DateTimeStamp concurrentProcessNonStringReferencesStart;
        private double concurrentProcessNonStrongReferencesDuration;
        private DateTimeStamp concurrentResetRelocationSetStart;
        private double concurrentResetRelocationSetDuration;
        private DateTimeStamp concurrentSelectRelocationSetStart;
        private double concurrentSelectRelocationSetDuration;
        private DateTimeStamp concurrentSelectRelocateStart;
        private double concurrentSelectRelocateDuration;
        private DateTimeStamp concurrentMarkContinueStart;
        private double concurrentMarkContinueDuration;
        private ZGCHeapCapacitySummary heapCapacitySummary;
        private ZGCMemoryPoolSummary markStart;
        private ZGCMemoryPoolSummary markEnd;
        private ZGCMemoryPoolSummary relocatedStart;
        private ZGCMemoryPoolSummary relocateEnd;
        private ZGCLiveSummary liveSummary;
        private ZGCAllocatedSummary allocatedSummary;
        private ZGCGarbageSummary garbageSummary;
        private ZGCReclaimSummary reclaimSummary;
        private ZGCMemorySummary memorySummary;
        private ZGCMetaspaceSummary metaspaceSummary;
        private ZGCMarkSummary markSummary;
        private double[] load = new double[3];
        private double[] mmu = new double[6];
        private DateTimeStamp concurrentRemapRootsStart;
        private double concurrentRemapRootsDuration;
        private DateTimeStamp markRootsStart;
        private double markRootsDuration;
        private DateTimeStamp markFollowStart;
        private double markFollowDuration;
        private DateTimeStamp remapRootColoredStart;
        private double remapRootsColoredDuration;
        private DateTimeStamp remapRootsUncoloredStart;
        private double remapRootsUncoloredDuration;
        private DateTimeStamp remapRememberedStart;
        private double remapRememberedDuration;
        private ZGCPromotedSummary promotedSummary;
        private ZGCCompactedSummary compactedSummary;
        private Double gcDuration;
        private OccupancySummary usedOccupancySummary;
        private ZGCReferenceSummary softRefSummary;
        private ZGCReferenceSummary weakRefSummary;
        private ZGCReferenceSummary finalRefSummary;
        private ZGCReferenceSummary phantomRefSummary;
        private ZGCNMethodSummary nMethodSummary;
        private ZGCPageSummary smallPageSummary;
        private ZGCPageSummary mediumPageSummary;
        private ZGCPageSummary largePageSummary;
        private long forwardingUsage;
        private List<ZGCPageAgeSummary> ageTableSummary;

        public ZGCForwardReference(DateTimeStamp dateTimeStamp, long gcId, GCCause cause, ZGCCollectionType type, ZGCPhase phase) {
            this.startTimeStamp = dateTimeStamp;
            this.gcId = gcId;
            this.gcCause = cause;
            this.type = type;
            this.phase = phase;
        }

        @Override
        public GCEvent getGCEVent(DateTimeStamp endTime) {
            GarbageCollectionTypes gcType = GarbageCollectionTypes.Unknown;
            switch (this.type) {
                case FULL: {
                    gcType = GarbageCollectionTypes.ZGCFull;
                    break;
                }
                case MINOR: {
                    gcType = GarbageCollectionTypes.ZGCMinor;
                    break;
                }
                case MAJOR: {
                    gcType = GarbageCollectionTypes.ZGCMajor;
                }
            }
            ZGCCycle delegate = this.getZGCCycle(endTime);
            FullZGCCycle fullZGCCycle = this.gcDuration != null ? new FullZGCCycle(this.startTimeStamp, gcType, this.gcCause, this.gcDuration, delegate) : new FullZGCCycle(this.startTimeStamp, gcType, this.gcCause, endTime.minus(this.startTimeStamp), delegate);
            return fullZGCCycle;
        }

        public ZGCCycle getZGCCycle(DateTimeStamp endTime) {
            ZGCCycle cycle = new ZGCCycle();
            cycle.setGcId(this.gcId);
            cycle.setType(this.type);
            cycle.setPhase(this.phase);
            cycle.setPauseMarkStart(this.pauseMarkStart, this.pauseMarkStartDuration);
            cycle.setConcurrentMark(this.concurrentMarkStart, this.concurrentMarkDuration);
            cycle.setConcurrentMarkContinue(this.concurrentMarkContinueStart, this.concurrentMarkContinueDuration);
            cycle.setConcurrentMarkFree(this.concurrentMarkFreeStart, this.concurrentMarkFreeDuration);
            cycle.setPauseMarkEnd(this.pauseMarkEndStart, this.pauseMarkEndDuration);
            cycle.setMarkRoots(this.markRootsStart, this.markRootsDuration);
            cycle.setMarkFollow(this.markFollowStart, this.markFollowDuration);
            cycle.setRemapRootsColored(this.remapRootColoredStart, this.remapRootsColoredDuration);
            cycle.setRemapRootsUncolored(this.remapRootsUncoloredStart, this.remapRootsUncoloredDuration);
            cycle.setRemapRemembered(this.remapRememberedStart, this.remapRememberedDuration);
            cycle.setConcurrentProcessNonStrongReferences(this.concurrentProcessNonStringReferencesStart, this.concurrentProcessNonStrongReferencesDuration);
            cycle.setConcurrentResetRelocationSet(this.concurrentResetRelocationSetStart, this.concurrentResetRelocationSetDuration);
            cycle.setConcurrentSelectRelocationSet(this.concurrentSelectRelocationSetStart, this.concurrentSelectRelocationSetDuration);
            cycle.setPauseRelocateStart(this.pauseRelocateStart, this.pauseRelocateStartDuration);
            cycle.setConcurrentRelocate(this.concurrentSelectRelocateStart, this.concurrentSelectRelocateDuration);
            cycle.setConcurrentRemapRoots(this.concurrentRemapRootsStart, this.concurrentRemapRootsDuration);
            cycle.setPromotedSummary(this.promotedSummary);
            cycle.setCompactedSummary(this.compactedSummary);
            cycle.setusedOccupancySummary(this.usedOccupancySummary);
            cycle.setSoftRefSummary(this.softRefSummary);
            cycle.setWeakRefSummary(this.weakRefSummary);
            cycle.setFinalRefSummary(this.finalRefSummary);
            cycle.setPhantomRefSummary(this.phantomRefSummary);
            cycle.setHeapCapacitySummary(this.heapCapacitySummary);
            cycle.setMarkStart(this.markStart);
            cycle.setMarkEnd(this.markEnd);
            cycle.setRelocateStart(this.relocatedStart);
            cycle.setRelocateEnd(this.relocateEnd);
            cycle.setLiveSummary(this.liveSummary);
            cycle.setAllocatedSummary(this.allocatedSummary);
            cycle.setGarbageSummary(this.garbageSummary);
            cycle.setReclaimSummary(this.reclaimSummary);
            cycle.setMemorySummary(this.memorySummary);
            cycle.setMetaspaceSummary(this.metaspaceSummary);
            cycle.setLoadAverages(this.load);
            cycle.setMMU(this.mmu);
            cycle.setMarkSummary(this.markSummary);
            cycle.setNMethodSummary(this.nMethodSummary);
            cycle.setSmallPageSummary(this.smallPageSummary);
            cycle.setMediumPageSummary(this.mediumPageSummary);
            cycle.setLargePageSummary(this.largePageSummary);
            cycle.setForwardingUsage(this.forwardingUsage);
            cycle.setAgeTableSummary(this.ageTableSummary);
            return cycle;
        }

        public void setPauseMarkStart(DateTimeStamp pauseMarkStart) {
            this.pauseMarkStart = pauseMarkStart;
        }

        public void setPauseMarkStartDuration(double pauseMarkStartDuration) {
            this.pauseMarkStartDuration = pauseMarkStartDuration;
        }

        public void setPauseMarkEndStart(DateTimeStamp pauseMarkEndStart) {
            this.pauseMarkEndStart = pauseMarkEndStart;
        }

        public void setPauseMarkEndDuration(double pauseMarkEndDuration) {
            this.pauseMarkEndDuration = pauseMarkEndDuration;
        }

        public void setPauseRelocateStart(DateTimeStamp pauseRelocateStart) {
            this.pauseRelocateStart = pauseRelocateStart;
        }

        public void setPauseRelocateStartDuration(double pauseRelocateStartDuration) {
            this.pauseRelocateStartDuration = pauseRelocateStartDuration;
        }

        public void setConcurrentMarkStart(DateTimeStamp concurrentMarkStart) {
            this.concurrentMarkStart = concurrentMarkStart;
        }

        public void setConcurrentMarkDuration(double concurrentMarkDuration) {
            this.concurrentMarkDuration = concurrentMarkDuration;
        }

        public void setConcurrentMarkFreeStart(DateTimeStamp concurrentMarkFreeStart) {
            this.concurrentMarkFreeStart = concurrentMarkFreeStart;
        }

        public void setConcurrentMarkFreeDuration(double concurrentMarkFreeDuration) {
            this.concurrentMarkFreeDuration = concurrentMarkFreeDuration;
        }

        public void setConcurrentProcessNonStringReferencesStart(DateTimeStamp concurrentProcessNonStringReferencesStart) {
            this.concurrentProcessNonStringReferencesStart = concurrentProcessNonStringReferencesStart;
        }

        public void setConcurrentProcessNonStrongReferencesDuration(double concurrentProcessNonStrongReferencesDuration) {
            this.concurrentProcessNonStrongReferencesDuration = concurrentProcessNonStrongReferencesDuration;
        }

        public void setConcurrentResetRelocationSetStart(DateTimeStamp concurrentResetRelocationSetStart) {
            this.concurrentResetRelocationSetStart = concurrentResetRelocationSetStart;
        }

        public void setConcurrentResetRelocationSetDuration(double concurrentResetRelocationSetDuration) {
            this.concurrentResetRelocationSetDuration = concurrentResetRelocationSetDuration;
        }

        public void setConcurrentSelectRelocationSetStart(DateTimeStamp concurrentSelectRelocationSetStart) {
            this.concurrentSelectRelocationSetStart = concurrentSelectRelocationSetStart;
        }

        public void setConcurrentSelectRelocationSetDuration(double concurrentSelectRelocationSetDuration) {
            this.concurrentSelectRelocationSetDuration = concurrentSelectRelocationSetDuration;
        }

        public void setConcurrentSelectRelocateStart(DateTimeStamp concurrentSelectRelocateStart) {
            this.concurrentSelectRelocateStart = concurrentSelectRelocateStart;
        }

        public void setConcurrentSelectRelocateDuration(double concurrentSelectRelocateDuration) {
            this.concurrentSelectRelocateDuration = concurrentSelectRelocateDuration;
        }

        public void setMarkStart(ZGCMemoryPoolSummary summary) {
            this.markStart = summary;
        }

        public void setMarkEnd(ZGCMemoryPoolSummary summary) {
            this.markEnd = summary;
        }

        public void setRelocateStart(ZGCMemoryPoolSummary summary) {
            this.relocatedStart = summary;
        }

        public void setRelocateEnd(ZGCMemoryPoolSummary summary) {
            this.relocateEnd = summary;
        }

        public void setMarkedLiveSummary(ZGCLiveSummary summary) {
            this.liveSummary = summary;
        }

        public void setAllocatedSummary(ZGCAllocatedSummary summary) {
            this.allocatedSummary = summary;
        }

        public void setGarbageSummary(ZGCGarbageSummary summary) {
            this.garbageSummary = summary;
        }

        public void setReclaimSummary(ZGCReclaimSummary summary) {
            this.reclaimSummary = summary;
        }

        public void setMemorySummary(ZGCMemorySummary summary) {
            this.memorySummary = summary;
        }

        public void setMetaspaceSummary(ZGCMetaspaceSummary summary) {
            this.metaspaceSummary = summary;
        }

        public void setLoad(double[] load) {
            this.load = load;
        }

        public void setMMU(double[] mmu) {
            this.mmu = mmu;
        }

        public void setConcurrentMarkContinueStart(DateTimeStamp startTime) {
            this.concurrentMarkContinueStart = startTime;
        }

        public void setConcurrentMarkContinueDuration(double duration) {
            this.concurrentMarkContinueDuration = duration;
        }

        public void setConcurrentRemapRootsStart(DateTimeStamp startTime) {
            this.concurrentRemapRootsStart = startTime;
        }

        public void setConcurrentRemapRootsDuration(double duration) {
            this.concurrentRemapRootsDuration = duration;
        }

        public void setMarkRootsStart(DateTimeStamp startTime) {
            this.markRootsStart = startTime;
        }

        public void setMarkRootsDuration(double duration) {
            this.markRootsDuration = duration;
        }

        public void setMarkFollowStart(DateTimeStamp markFollowStart) {
            this.markFollowStart = markFollowStart;
        }

        public void setMarkFollowDuration(double markFollowDuration) {
            this.markFollowDuration = markFollowDuration;
        }

        public void setRemapRootsColoredStart(DateTimeStamp remapRootColoredStart) {
            this.remapRootColoredStart = remapRootColoredStart;
        }

        public void setRemapRootsColoredDuration(double remapRootsColoredDuration) {
            this.remapRootsColoredDuration = remapRootsColoredDuration;
        }

        public void setRemapRootsUncoloredStart(DateTimeStamp remapRootsUncoloredStart) {
            this.remapRootsUncoloredStart = remapRootsUncoloredStart;
        }

        public void setRemapRootsUncoloredDuration(double remapRootsUncoloredDuration) {
            this.remapRootsUncoloredDuration = remapRootsUncoloredDuration;
        }

        public void setRemapRememberedStart(DateTimeStamp remapRememberedStart) {
            this.remapRememberedStart = remapRememberedStart;
        }

        public void setRemapRememberedDuration(double remapRememberedDuration) {
            this.remapRememberedDuration = remapRememberedDuration;
        }

        public void setMarkSummary(ZGCMarkSummary markSummary) {
            this.markSummary = markSummary;
        }

        public void setPromotedSummary(ZGCPromotedSummary promotedSummary) {
            this.promotedSummary = promotedSummary;
        }

        public void setCompactedSummary(ZGCCompactedSummary compactedSummary) {
            this.compactedSummary = compactedSummary;
        }

        public void setGcDuration(double gcDuration) {
            this.gcDuration = gcDuration;
        }

        public void setUsed(ZGCPhase phase, OccupancySummary summary) {
            switch (phase) {
                case FULL: {
                    break;
                }
                case MAJOR_YOUNG: 
                case MAJOR_OLD: 
                case MINOR_YOUNG: {
                    this.usedOccupancySummary = summary;
                }
            }
        }

        public void setSoftRefSummary(ZGCReferenceSummary summary) {
            this.softRefSummary = summary;
        }

        public void setWeakRefSummary(ZGCReferenceSummary weakRefSummary) {
            this.weakRefSummary = weakRefSummary;
        }

        public void setFinalRefSummary(ZGCReferenceSummary finalRefSummary) {
            this.finalRefSummary = finalRefSummary;
        }

        public void setPhantomRefSummary(ZGCReferenceSummary phantomRefSummary) {
            this.phantomRefSummary = phantomRefSummary;
        }

        public void setHeapCapacitySummary(ZGCHeapCapacitySummary heapCapacitySummary) {
            this.heapCapacitySummary = heapCapacitySummary;
        }

        public void setNMethodSummary(ZGCNMethodSummary nMethodSummary) {
            this.nMethodSummary = nMethodSummary;
        }

        public void setSmallPageSummary(ZGCPageSummary smallPageSummary) {
            this.smallPageSummary = smallPageSummary;
        }

        public void setMediumPageSummary(ZGCPageSummary mediumPageSummary) {
            this.mediumPageSummary = mediumPageSummary;
        }

        public void setLargePageSummary(ZGCPageSummary largePageSummary) {
            this.largePageSummary = largePageSummary;
        }

        public void setForwardingUsage(long forwardingUsage) {
            this.forwardingUsage = forwardingUsage;
        }

        public void addPageAgeSummary(ZGCPageAgeSummary summary) {
            if (this.ageTableSummary == null) {
                this.ageTableSummary = new ArrayList<ZGCPageAgeSummary>();
            }
            this.ageTableSummary.add(summary);
        }
    }

    private static class ZGCMajorForwardReference
    implements ZForwardReference {
        private final DateTimeStamp startTimeStamp;
        private final GCCause gcCause;
        private final ZGCCollectionType type;
        private final long gcId;
        private ZGCMemorySummary cycleMemorySummary;
        private final ZGCForwardReference youngGeneration;
        private final ZGCForwardReference oldGeneration;

        public ZGCMajorForwardReference(DateTimeStamp dateTimeStamp, long gcId, GCCause cause, ZGCCollectionType type) {
            this.startTimeStamp = dateTimeStamp;
            this.gcCause = cause;
            this.type = type;
            this.gcId = gcId;
            this.youngGeneration = new ZGCForwardReference(dateTimeStamp, gcId, cause, type, ZGCPhase.MAJOR_YOUNG);
            this.oldGeneration = new ZGCForwardReference(dateTimeStamp, gcId, cause, type, ZGCPhase.MAJOR_OLD);
        }

        public ZGCForwardReference getYoungGeneration() {
            return this.youngGeneration;
        }

        public ZGCForwardReference getOldGeneration() {
            return this.oldGeneration;
        }

        public void setMemorySummary(ZGCMemorySummary cycleMemorySummary) {
            this.cycleMemorySummary = cycleMemorySummary;
        }

        @Override
        public GCEvent getGCEVent(DateTimeStamp endTime) {
            GarbageCollectionTypes gcType = GarbageCollectionTypes.Unknown;
            switch (this.type) {
                case FULL: {
                    gcType = GarbageCollectionTypes.ZGCFull;
                    break;
                }
                case MINOR: {
                    gcType = GarbageCollectionTypes.ZGCMinor;
                    break;
                }
                case MAJOR: {
                    gcType = GarbageCollectionTypes.ZGCMajor;
                }
            }
            MajorZGCCycle cycle = new MajorZGCCycle(this.startTimeStamp, gcType, this.gcCause, endTime.minus(this.startTimeStamp));
            cycle.setYoungCycle(this.youngGeneration.getZGCCycle(endTime));
            cycle.setOldCycle(this.oldGeneration.getZGCCycle(endTime));
            cycle.setMemorySummary(this.cycleMemorySummary);
            cycle.setGcId(this.gcId);
            return cycle;
        }
    }

    private static class ZGCMinorForwardReference
    implements ZForwardReference {
        private final DateTimeStamp startTimeStamp;
        private final GCCause gcCause;
        private final ZGCCollectionType type;
        private final long gcId;
        private ZGCMemorySummary cycleMemorySummary;
        private ZGCForwardReference youngGeneration;

        public ZGCMinorForwardReference(DateTimeStamp dateTimeStamp, long gcId, GCCause cause, ZGCCollectionType type) {
            this.startTimeStamp = dateTimeStamp;
            this.gcCause = cause;
            this.type = type;
            this.gcId = gcId;
            this.youngGeneration = new ZGCForwardReference(dateTimeStamp, gcId, cause, type, ZGCPhase.MINOR_YOUNG);
        }

        public ZGCForwardReference getYoungGeneration() {
            return this.youngGeneration;
        }

        @Override
        public GCEvent getGCEVent(DateTimeStamp endTime) {
            GarbageCollectionTypes gcType = GarbageCollectionTypes.Unknown;
            switch (this.type) {
                case FULL: {
                    gcType = GarbageCollectionTypes.ZGCFull;
                    break;
                }
                case MINOR: {
                    gcType = GarbageCollectionTypes.ZGCMinor;
                    break;
                }
                case MAJOR: {
                    gcType = GarbageCollectionTypes.ZGCMajor;
                }
            }
            MinorZGCCycle cycle = new MinorZGCCycle(this.startTimeStamp, gcType, this.gcCause, endTime.minus(this.startTimeStamp));
            cycle.setYoungCycle(this.youngGeneration.getZGCCycle(endTime));
            cycle.setMemorySummary(this.cycleMemorySummary);
            cycle.setGcId(this.gcId);
            return cycle;
        }

        public void setMemorySummary(ZGCMemorySummary cycleMemorySummary) {
            this.cycleMemorySummary = cycleMemorySummary;
        }
    }

    private static interface ZForwardReference {
        public GCEvent getGCEVent(DateTimeStamp var1);
    }
}

