/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.jvm;

import com.microsoft.gctoolkit.parser.unified.UnifiedLoggingLevel;
import com.microsoft.gctoolkit.parser.unified.UnifiedLoggingTokens;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class Decorators {
    private static final Logger LOGGER = Logger.getLogger(Decorators.class.getName());
    private static final long TWENTY_YEARS_IN_MILLIS = 63158400000L;
    private static final long TWENTY_YEARS_IN_NANO = 63158400000L;
    int numberOfDecorators;
    private Matcher decoratorMatcher = null;
    private String tags;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public Decorators(String line) {
        this.extractValues(line);
    }

    private void extractValues(String line) {
        if (!line.startsWith("[")) {
            return;
        }
        this.decoratorMatcher = UnifiedLoggingTokens.DECORATORS.matcher(line);
        if (!this.decoratorMatcher.find()) {
            return;
        }
        for (int i = 1; i <= this.decoratorMatcher.groupCount(); ++i) {
            if (this.decoratorMatcher.group(i) == null) continue;
            ++this.numberOfDecorators;
        }
        Matcher tagMatcher = UnifiedLoggingTokens.TAGS.matcher(line);
        if (tagMatcher.find()) {
            ++this.numberOfDecorators;
            this.tags = String.join((CharSequence)",", Arrays.asList(tagMatcher.group(1).trim().split(",")));
        }
    }

    public ZonedDateTime getDateStamp() {
        try {
            String value = this.decoratorMatcher.group(1);
            if (value != null) {
                TemporalAccessor temporalAccessor = formatter.parse(value.substring(1, value.length() - 1));
                return ZonedDateTime.from(temporalAccessor);
            }
        }
        catch (NullPointerException npe) {
            LOGGER.log(Level.SEVERE, npe.getMessage(), npe);
        }
        return null;
    }

    public double getUpTime() {
        String value = this.decoratorMatcher.group(2);
        if (value != null) {
            value = value.replace(",", ".");
            return Double.parseDouble(this.unboxValue(value, 1));
        }
        return -1.0;
    }

    private long extractClock(int groupIndex, long threshold) {
        long clockReading = -1L;
        String stringValue = this.decoratorMatcher.group(groupIndex);
        if (stringValue != null) {
            clockReading = Long.parseLong(this.unboxValue(stringValue, 2));
            if (this.decoratorMatcher.group(groupIndex + 1) == null && clockReading < threshold) {
                clockReading = -1L;
            }
        }
        return clockReading;
    }

    public long getTimeMillis() {
        return this.extractClock(3, 63158400000L);
    }

    public long getUptimeMillis() {
        long longValue;
        String value = this.decoratorMatcher.group(4);
        if (value == null) {
            value = this.decoratorMatcher.group(3);
        }
        if (value != null && (longValue = Long.parseLong(this.unboxValue(value, 2))) < 63158400000L) {
            return longValue;
        }
        return -1L;
    }

    public long getTimeNano() {
        return this.extractClock(5, 63158400000L);
    }

    public long getUptimeNano() {
        long longValue;
        String value = this.decoratorMatcher.group(6);
        if (value == null) {
            value = this.decoratorMatcher.group(5);
        }
        if (value != null && (longValue = Long.parseLong(this.unboxValue(value, 2))) < 63158400000L) {
            return longValue;
        }
        return -1L;
    }

    public int getPid() {
        String value = this.decoratorMatcher.group(7);
        if (value != null) {
            return Integer.parseInt(this.unboxValue(value));
        }
        return -1;
    }

    public int getTid() {
        String value = this.decoratorMatcher.group(8);
        if (value != null) {
            return Integer.parseInt(this.unboxValue(value));
        }
        return -1;
    }

    public Optional<UnifiedLoggingLevel> getLogLevel() {
        String level = this.decoratorMatcher.group(9);
        if (level != null) {
            try {
                return Optional.of(UnifiedLoggingLevel.valueOf(this.unboxValue(level)));
            }
            catch (IllegalArgumentException e) {
                LOGGER.fine("No such debug level: " + level);
                LOGGER.fine(e.getMessage());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public DateTimeStamp getDateTimeStamp() {
        return new DateTimeStamp(this.getDateStamp(), this.getUpTime());
    }

    public int getNumberOfDecorators() {
        return this.numberOfDecorators;
    }

    private String unboxValue(String boxedValue, int postFix) {
        return boxedValue.substring(1, boxedValue.length() - (1 + postFix));
    }

    private String unboxValue(String boxedValue) {
        return this.unboxValue(boxedValue, 0).trim();
    }

    public boolean tagsContain(String tagList) {
        return this.tags.contains(tagList);
    }

    public String getTags() {
        return this.tags;
    }
}

