var h = (window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight) - 45;
var scrolling = false;
var current_graph_id = location.hash;

var params = {};
location.search.substr(1).split("&").forEach(function (part) {
  var item = part.split("=");
  params[item[0]] = decodeURIComponent(item[1]);
});

var compare_to = params['compare_to'];
var overlap = params['overlap'];

function switch_overlap(overlap) {
  location.href = "?overlap=" + overlap + "&compare_to=" + compare_to + current_graph_id;
}

function selectCompare() {
  var msg = "Please enter URL of another all-graphs.html";
  if (compare_to != null && compare_to !== "") {
    msg += "\nLeave empty to switch to a single-file mode.";
  }
  var res = prompt(msg);
  if (res == null) {
    location.href = current_graph_id;
  } else if (res.search("/all-graphs.html") > 0) {
    compare_to = res.replace(/\/all-graphs.html.*/, "");
    switch_overlap(false);
  } else {
    location.href = (location.origin === "null" ? "" : location.origin) + location.pathname + current_graph_id;
  }
}

function setGraphs(logname, info) {
  var graphs = info.graphs;
  var a = "<a href=\"javascript:selectCompare()\">Compare to ...</a>";
  if (compare_to != null && compare_to !== "") {
    a += (overlap === "true")
            ? " <a href=\"javascript:switch_overlap(false)\">Side-by-side</a>"
            : " <a href=\"javascript:switch_overlap(true)\">Overlap</a>";
  }
  var i = "";
  var cat = "";
  var l = "<a id=\"l_info\" href=\"#info\">Summary</a>";
  var gr;
  for (gr in graphs) {
    g = graphs[gr];
    if (cat !== g.category) {
      cat = g.category;
      l += "<br><br><span class='category'>" + g.category + "</span>";
    }
    if (g.fname !== "nodata") {
      l += "<br>&nbsp;<span id=\"l_" + g.id + "\"><a href=\"#" + g.id + "\">" + g.title + "</a></span>";
      if (compare_to != null && compare_to !== "") {
        if (overlap === 'true') {
          i += "<br><div class=\"graph_div\" id=\"" + g.id + "\" style=\"position: relative;\">";
          i += "<img class=\"graph_img\" style=\"position: absolute;\" src=\"./png-files/" + g.fname + "\">";
          i += "<img class=\"graph_img\" style=\"position: absolute; opacity: 0.5;\" src=\"" + compare_to + "/png-files/" + g.fname + "\">";
          i += "</div>";
        } else {
          i += "<br><div class=\"graph_div\" id=\"" + g.id + "\" style=\"width: 50%;\">";
          i += "<img class=\"graph_img\" src=\"./png-files/" + g.fname + "\">";
          i += "<img class=\"graph_img\" src=\"" + compare_to + "/png-files/" + g.fname + "\">";
          i += "</div>";
        }
      } else {
        i += "<br><div class=\"graph_div\" id=\"" + g.id + "\" style=\"height: " + h + "px;\">";
        i += "<img class=\"graph_img\" src=\"./png-files/" + g.fname + "\">";
        i += "</div>";
      }
    } else {
      l += "<br>&nbsp;<span class=\"disabled\">" + g.title + "</span>";
    }
  }
  document.getElementById("gclog").innerHTML = "GC Log: " + logname;
  document.getElementById("actions").innerHTML = a;
  document.getElementById("graph-list").innerHTML = l;
  document.getElementById("images").innerHTML = i;
  $(document.getElementById("right")).scroll(function () {
    scrolling = true;
  });
}

setInterval(function () {
  if (scrolling) {
    scrolling = false;
    handleScroll();
  }
}, 250);

function handleScroll() {
  var wtop = $(window).scrollTop();
  var wbot = wtop + $(window).height();
  var max_vis = 0;
  var max_li;
  $(".graph_div").each(function () {
    var top = $(this).offset().top;
    var bot = top + $(this).height();
    var id = $(this).attr("id");
    if (id != null) {
      var li = document.getElementById("l_" + id);
      li.classList.remove("selected");
      if (top < wbot && bot > wtop) {
        var vis = (top < wtop) ? bot - wtop : wbot - top;
        if (vis > max_vis) {
          max_vis = vis;
          max_li = li;
        }
      }
    }
  });
  if (max_li != null) {
    current_graph_id = max_li.id.replace("l_", "#");
    max_li.classList.add("selected");
    if ($(max_li).offset().top > wbot || $(max_li).offset().top + $(max_li).height() < wtop) {
      max_li.scrollIntoView();
    }
  }
}
