/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.functional;

import com.azul.gulp.ThrowingFunction;
import com.azul.gulp.functional.inject.InjectionAwareFunction;
import com.azul.gulp.functional.inject.InjectionAwarePredicate;
import com.azul.gulp.inject.InjectionContext;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class Predicates {
    private static final Predicate<Object> ANY = new Predicate<Object>(){

        @Override
        public final boolean test(Object value) {
            return true;
        }
    };
    private static final Predicate<Object> NOT_NULL = new Predicate<Object>(){

        @Override
        public final boolean test(Object value) {
            return value != null;
        }
    };

    private Predicates() {
    }

    public static boolean isAny(Predicate<?> predicate) {
        return predicate == ANY;
    }

    public static <T> Predicate<T> any() {
        Predicate<Object> casted = ANY;
        return casted;
    }

    public static <T> Predicate<T> not(final Predicate<? super T> predicate) {
        return new InjectionAwarePredicate<T>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(predicate);
            }

            @Override
            public final boolean test(T value) {
                return !predicate.test(value);
            }
        };
    }

    public static <T> Predicate<T> notNull() {
        Predicate<Object> casted = NOT_NULL;
        return casted;
    }

    public static <T> Predicate<T> and(final Predicate<? super T> lhs, final Predicate<? super T> rhs) {
        return new InjectionAwarePredicate<T>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(lhs);
                ctx.inject(rhs);
            }

            @Override
            public boolean test(T value) {
                return lhs.test(value) && rhs.test(value);
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> lhs, final Predicate<? super T> rhs) {
        return new InjectionAwarePredicate<T>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(lhs);
                ctx.inject(rhs);
            }

            @Override
            public boolean test(T value) {
                return lhs.test(value) || rhs.test(value);
            }
        };
    }

    public static <T> Predicate<T> unique() {
        return new Predicate<T>(){
            private final Set<T> seen = new HashSet(64);

            @Override
            public final boolean test(T value) {
                return this.seen.add(value);
            }
        };
    }

    public static <T> Predicate<T> unique(final ThrowingFunction<? super T, ?> transformFn) {
        return new Predicate<T>(){
            private final Set<Object> seen = new HashSet<Object>(64);

            @Override
            public final boolean test(T value) {
                try {
                    return this.seen.add(transformFn.apply(value));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static <T> ThrowingFunction<T, Boolean> asFunction(final Predicate<? super T> predicate) {
        return new InjectionAwareFunction<T, Boolean>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(predicate);
            }

            @Override
            public final Boolean apply(T input) {
                return predicate.test(input);
            }
        };
    }
}

