/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.inject;

import com.azul.gulp.Gulp;
import com.azul.gulp.inject.ExactInjector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ConstructorInjector<T>
implements ExactInjector {
    private final Constructor<T> injectableCtor;
    private final Object[] params;

    public ConstructorInjector(Class<T> type) {
        this.injectableCtor = ConstructorInjector.getInjectableCtor(type);
        this.params = new Object[this.injectableCtor.getParameterTypes().length];
    }

    private static <T> Constructor<T> getInjectableCtor(Class<T> type) {
        Constructor<?>[] ctors = type.getDeclaredConstructors();
        Constructor<?> injectableCtor = null;
        for (Constructor<?> ctor : ctors) {
            if (!ctor.isAnnotationPresent(Gulp.Inject.class)) continue;
            if (injectableCtor != null) {
                throw new IllegalStateException("Two injectable constructors!");
            }
            injectableCtor = ctor;
            injectableCtor.setAccessible(true);
        }
        if (injectableCtor != null) {
            return ConstructorInjector.cast(injectableCtor);
        }
        if (ctors.length != 1) {
            throw new IllegalStateException("ambiguous constructor choice");
        }
        Constructor<?> ctor = ctors[0];
        ctor.setAccessible(true);
        return ConstructorInjector.cast(ctor);
    }

    private static <T> Constructor<T> cast(Constructor<?> ctor) {
        Constructor<?> casted = ctor;
        return casted;
    }

    @Override
    public Set<Type> requires() {
        Type[] types = this.injectableCtor.getGenericParameterTypes();
        if (types.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Type> typeSet = new HashSet<Type>(types.length);
        typeSet.addAll(Arrays.asList(types));
        return Collections.unmodifiableSet(typeSet);
    }

    @Override
    public void inject(Type type, Object value) {
        Type[] types = this.injectableCtor.getGenericParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(type)) continue;
            this.params[i] = value;
        }
    }

    public final T make() {
        try {
            return this.injectableCtor.newInstance(this.params);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

