/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.nexus;

import com.azul.gulp.ConfigurationException;
import com.azul.gulp.Emitter;
import com.azul.gulp.HandledMarker;
import com.azul.gulp.inject.ConstructorInjector;
import com.azul.gulp.inject.FieldInjector;
import com.azul.gulp.inject.InjectionAware;
import com.azul.gulp.kernel.Kernel;
import com.azul.gulp.nexus.CompositePlugin;
import com.azul.gulp.nexus.FlexNexusHandler;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusEmitter;
import com.azul.gulp.nexus.NexusHandledMarker;
import com.azul.gulp.nexus.NexusHandler;
import com.azul.gulp.nexus.NexusNormalizer;
import com.azul.gulp.nexus.NexusUnhandler;
import com.azul.gulp.nexus.Plugin;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class NexusImpl
implements Nexus {
    private final Kernel kernel = new Kernel();
    private final Plugin plugins;
    private final Set<Class<?>> availableTypes = new HashSet();
    private final Set<Class<?>> requestedTypes = new HashSet();
    private final Map<Class<?>, Object> ctxObjects = new HashMap();

    public NexusImpl(Collection<Class<?>> coreTypes, List<Plugin> plugins) {
        this.availableTypes.addAll(coreTypes);
        this.plugins = new CompositePlugin(plugins);
    }

    @Override
    public final void inject(Object obj) {
        FieldInjector injector = new FieldInjector(obj);
        for (Type requiredType : injector.requires()) {
            injector.inject(requiredType, this.getOrCreate(requiredType));
        }
        if (obj instanceof InjectionAware) {
            InjectionAware injectionAware = (InjectionAware)obj;
            injectionAware.onInject(this);
        }
        try {
            this.plugins.onConnect(this, obj);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public <T> void normalize(Class<T> type, NexusNormalizer<T> normalizer) {
        this.require((Class)type);
        this.inject(normalizer);
        try {
            normalizer.init(this);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        this.kernel.normalize(type, normalizer);
    }

    @Override
    public <T> NexusEmitter<T> getEmitter(Class<T> type) {
        this.supply(type);
        return this.kernel.asTypeEmitter(type);
    }

    @Override
    public <T> NexusHandledMarker<T> getMarker(Class<T> type) {
        return this.kernel.asTypeMarker(type);
    }

    @Override
    public void connect(Object obj) {
        boolean connected;
        try {
            connected = this.plugins.connect(this, obj);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        if (!connected) {
            throw new ConfigurationException("connect!");
        }
        this.inject(obj);
        try {
            this.plugins.onConnect(this, obj);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public <V> void handle(Class<V> type, NexusHandler<? super V> handler) {
        this.require(type);
        this.inject(handler);
        try {
            handler.init(this);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        this.kernel.handle(type, handler);
    }

    public <V> void handleOptional(Class<V> type, NexusHandler<? super V> handler) {
        boolean satisfied = this.request(type);
        if (!satisfied) {
            return;
        }
        this.inject(handler);
        try {
            handler.init(this);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        this.kernel.handle(type, handler);
    }

    public <V> void remove(Class<V> type, NexusHandler<? super V> handler) {
        this.kernel.remove(type, handler);
    }

    @Override
    public final void handle(FlexNexusHandler handler) {
        this.handle((Class)handler.type(), handler);
    }

    @Override
    public final void handleOptional(FlexNexusHandler handler) {
        this.handleOptional((Class)handler.type(), handler);
    }

    @Override
    public void remove(FlexNexusHandler handler) {
        this.remove((Class)handler.type(), handler);
    }

    @Override
    public final <T> void unhandle(Class<T> type, NexusUnhandler<? super T> unhandler) throws ConfigurationException {
        this.kernel.unhandle(type, unhandler);
    }

    @Override
    public final <T> void remove(Class<T> type, NexusUnhandler<? super T> unhandler) throws ConfigurationException {
        this.kernel.remove(type, unhandler);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.getOrCreate(type);
    }

    @Override
    public final <T> T get(Class<T> rawType, Class<?> ... typeParams) {
        if (rawType.equals(Emitter.class) && typeParams.length == 1) {
            final NexusEmitter<?> nexusEmitter = this.getEmitter(typeParams[0]);
            Emitter casted = new Emitter(){

                public void fire(Object value) {
                    nexusEmitter.fire(value);
                }
            };
            return (T)casted;
        }
        if (rawType.equals(HandledMarker.class) && typeParams.length == 1) {
            final NexusHandledMarker<?> nexusMarker = this.getMarker(typeParams[0]);
            HandledMarker casted = new HandledMarker(){

                public void mark(Object value) {
                    nexusMarker.mark(value);
                }
            };
            return (T)casted;
        }
        throw new ConfigurationException(rawType, typeParams);
    }

    private static <T> T cast(Object value) {
        Object casted = value;
        return (T)casted;
    }

    final Object getOrCreate(Type type) {
        if (type instanceof Class) {
            return this.getOrCreate((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return this.get((Class)paramType.getRawType(), NexusImpl.toClasses(paramType.getActualTypeArguments()));
        }
        throw new IllegalArgumentException();
    }

    private static Class<?>[] toClasses(Type[] types) {
        Class[] rawTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            rawTypes[i] = (Class)types[i];
        }
        return rawTypes;
    }

    @Override
    public <T> T create(Class<T> type) {
        ConstructorInjector<T> injector = new ConstructorInjector<T>(type);
        for (Type requiredType : injector.requires()) {
            injector.inject(requiredType, this.getOrCreate(requiredType));
        }
        T newObj = injector.make();
        try {
            this.plugins.connect(this, newObj);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(type, (Throwable)e);
        }
        return newObj;
    }

    final <T> T getOrCreate(Class<T> type) {
        Object existingObj = this.ctxObjects.get(type);
        if (existingObj != null) {
            return (T)existingObj;
        }
        T newObj = this.create(type);
        this.ctxObjects.put(type, newObj);
        return newObj;
    }

    @Override
    public final void require(Class<?> ... eventTypes) throws ConfigurationException {
        for (Class<?> eventType : eventTypes) {
            this.require((Class)eventType);
        }
    }

    private void supply(Class<?> type) throws ConfigurationException {
        if (!this.availableTypes.add(type)) {
            return;
        }
        try {
            this.plugins.onEventRequest(this, type);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(type, (Throwable)e);
        }
    }

    @Override
    public final boolean request(Class<?> ... eventTypes) throws ConfigurationException {
        boolean satisfied = true;
        for (Class<?> eventType : eventTypes) {
            satisfied |= this.request((Class)eventType);
        }
        return satisfied;
    }

    @Override
    public void produces(Class<?> ... types) {
        this.availableTypes.addAll(Arrays.asList(types));
    }

    final void require(Collection<? extends Class<?>> eventTypes) throws ConfigurationException {
        for (Class<?> eventType : eventTypes) {
            this.require((Class)eventType);
        }
    }

    final <V> boolean request(Class<V> type) throws ConfigurationException {
        boolean handled;
        if (this.availableTypes.contains(type)) {
            return true;
        }
        if (!this.requestedTypes.add(type)) {
            return true;
        }
        try {
            handled = this.plugins.handleEventRequest(this, type);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(type, (Throwable)e);
        }
        if (handled && !this.availableTypes.contains(type)) {
            throw new IllegalStateException("required type unvailable: " + type);
        }
        return handled;
    }

    final <V> void require(Class<V> type) throws ConfigurationException {
        boolean satisfied = this.request(type);
        if (!satisfied) {
            throw new ConfigurationException(type);
        }
    }
}

