/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.standardplugins;

import com.azul.gulp.Gulp;
import com.azul.gulp.Normalizer;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusNormalizer;
import com.azul.gulp.nexus.Plugin;
import java.lang.reflect.Constructor;

public final class NormalizerPlugin
extends Plugin {
    @Override
    public <V> void onEventRequest(Nexus engine, Class<V> requiredType) throws Exception {
        Gulp.Normalize normalizeAnno = requiredType.getAnnotation(Gulp.Normalize.class);
        if (normalizeAnno == null) {
            return;
        }
        final Normalizer<V> normalizer = NormalizerPlugin.createNormalizer(requiredType, normalizeAnno);
        engine.normalize(requiredType, new NexusNormalizer<V>(){

            @Override
            public void init(Nexus nexus) throws Exception {
                nexus.inject(normalizer);
            }

            @Override
            public final V normalize(V value) throws Exception {
                return normalizer.normalize(value);
            }
        });
    }

    @Override
    public final <V> boolean connect(Nexus engine, Object object) throws Exception {
        return false;
    }

    private static <T> Normalizer<T> createNormalizer(Class<T> type, Gulp.Normalize normalizeAnno) {
        Constructor<Normalizer<?>> ctor;
        try {
            ctor = normalizeAnno.value().getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        ctor.setAccessible(true);
        try {
            Normalizer<?> casted = ctor.newInstance(new Object[0]);
            return casted;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

