/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text;

import com.azul.gulp.io.IoProvider;
import com.azul.gulp.text.GulpTextLog;
import com.azul.gulp.text.LineSource;
import com.azul.gulp.text.support.AnnotatedRegexLineMatcher;
import com.azul.gulp.text.support.CompositeLineMatcher;
import java.io.File;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;

public final class GulpText {
    private GulpText() {
    }

    public static GulpTextLog gulpFile(String fileName) {
        return GulpText.gulpFile(new File(fileName));
    }

    public static GulpTextLog gulpFile(File fileName) {
        return new GulpTextLog(new LineSource(fileName));
    }

    public static GulpTextLog gulpLog(IoProvider<Reader> io) {
        return new GulpTextLog(new LineSource(io));
    }

    public static boolean isRegexBased(LineMatcher anno) {
        return !anno.regex().isEmpty();
    }

    public static boolean usesCustomClass(LineMatcher anno) {
        return !anno.value().equals(com.azul.gulp.text.LineMatcher.class);
    }

    public static <T> com.azul.gulp.text.LineMatcher<T> makeMatcherFrom(Class<T> dataClass, LineMatchers anno) {
        LineMatcher[] matcherAnnos = anno.value();
        com.azul.gulp.text.LineMatcher[] matchers = new com.azul.gulp.text.LineMatcher[matcherAnnos.length];
        for (int i = 0; i < matcherAnnos.length; ++i) {
            matchers[i] = GulpText.makeMatcherFrom(dataClass, matcherAnnos[i]);
        }
        return new CompositeLineMatcher(matchers);
    }

    public static <T> com.azul.gulp.text.LineMatcher<T> makeMatcherFrom(Class<T> dataClass, LineMatcher anno) {
        if (!anno.regex().isEmpty()) {
            return new AnnotatedRegexLineMatcher<T>(dataClass, anno.regex());
        }
        Class<? extends com.azul.gulp.text.LineMatcher> lineMatcherClass = anno.value();
        if (lineMatcherClass.equals(com.azul.gulp.text.LineMatcher.class)) {
            throw new IllegalStateException("either value or regex should be set");
        }
        try {
            try {
                Constructor<? extends com.azul.gulp.text.LineMatcher> ctor = lineMatcherClass.getDeclaredConstructor(Class.class);
                ctor.setAccessible(true);
                return ctor.newInstance(dataClass);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends com.azul.gulp.text.LineMatcher> ctor = lineMatcherClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Inherited
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LineMatcher {
        public String regex() default "";

        public Class<? extends com.azul.gulp.text.LineMatcher> value() default com.azul.gulp.text.LineMatcher.class;
    }

    @Inherited
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LineMatchers {
        public LineMatcher[] value();
    }
}

