/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexMatcher {
    private final Matcher matcher;
    private int nextGroup = 1;

    public static RegexMatcher match(Pattern pattern, CharSequence corpus) {
        return new RegexMatcher(pattern.matcher(corpus));
    }

    public RegexMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public final boolean matches() {
        return this.matcher.matches();
    }

    public final int groupCount() {
        return this.matcher.groupCount();
    }

    public final String group(int index) {
        return this.matcher.group(index);
    }

    public final int groupStart(int index) {
        return this.matcher.start(index);
    }

    public final int groupEnd(int index) {
        return this.matcher.end(index);
    }

    public final <T> T groupAs(int index, Class<? extends T> type) {
        return RegexMatcher.convert(this.group(index), type, null);
    }

    public final <T> T groupAs(int index, Class<? extends T> type, Object param) {
        return RegexMatcher.convert(this.group(index), type, param);
    }

    public final String stringAt(int index) {
        return this.group(index);
    }

    public final Integer intAt(int index) {
        return this.groupAs(index, Integer.class);
    }

    public final Integer intAt(int index, int base) {
        return this.groupAs(index, Integer.class, base);
    }

    public final Character charAt(int index) {
        return this.groupAs(index, Character.class);
    }

    public final Date dateAt(int index, DateFormat format) {
        return this.groupAs(index, Date.class, format);
    }

    public final long timeAt(int index, DateFormat format) {
        return this.dateAt(index, format).getTime();
    }

    public final String nextGroup() {
        return this.matcher.group(this.nextGroup++);
    }

    public final Double nextDouble() {
        return this.nextGroupAs(Double.class);
    }

    public final Integer nextInt() {
        return this.nextGroupAs(Integer.class);
    }

    public final Integer nextInt(int base) {
        return this.nextGroupAs(Integer.class, base);
    }

    public final Long nextLong() {
        return this.nextGroupAs(Long.class);
    }

    public final Long nextLong(int base) {
        return this.nextGroupAs(Long.class, base);
    }

    public final Date nextDate(DateFormat format) {
        return this.nextGroupAs(Date.class, format);
    }

    public final long nextTime(DateFormat format) {
        return this.nextDate(format).getTime();
    }

    public final Character nextChar() {
        return this.nextGroupAs(Character.class);
    }

    public final String nextString() {
        return this.nextGroup();
    }

    public final boolean hasNext() {
        return this.nextGroup < this.groupCount();
    }

    public final <T> T nextGroupAs(Class<? extends T> type) {
        return RegexMatcher.convert(this.nextGroup(), type, null);
    }

    public final <T> T nextGroupAs(Class<? extends T> type, Object param) {
        return RegexMatcher.convert(this.nextGroup(), type, param);
    }

    private static <T> T convert(String value, Class<? extends T> type, Object optionalParam) {
        if (type.equals(String.class)) {
            return RegexMatcher.cast(value);
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return RegexMatcher.cast(Character.valueOf(RegexMatcher.parseChar(value)));
        }
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            String normalizedValue = value.replace(",", "");
            int base = optionalParam == null ? 10 : (Integer)optionalParam;
            return RegexMatcher.cast(Integer.parseInt(normalizedValue, base));
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            String normalizedValue = value.replace(",", "");
            int base = optionalParam == null ? 10 : (Integer)optionalParam;
            return RegexMatcher.cast(Long.parseLong(normalizedValue, base));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            String normalizedValue = value.replace(",", "");
            return RegexMatcher.cast(Double.parseDouble(normalizedValue));
        }
        if (type.equals(Date.class)) {
            DateFormat format = (DateFormat)optionalParam;
            if (optionalParam == null) {
                throw new IllegalStateException("Must specify DateFormat");
            }
            try {
                return RegexMatcher.cast(format.parse(value.trim()));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new UnsupportedOperationException("unsupported type");
    }

    private static char parseChar(String value) {
        switch (value.length()) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                return value.charAt(0);
            }
        }
        throw new IllegalStateException("Expected single char match");
    }

    private static <T> T cast(Object value) {
        return (T)value;
    }

    public final String toString() {
        return this.matcher.toString();
    }
}

