/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text.support;

import com.azul.gulp.Emitter;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.gulp.text.RegexMatcher;
import java.util.regex.Pattern;

public abstract class RegexLineMatcher<T>
implements LineMatcher<T> {
    private final Pattern regex;
    private final boolean matchOriginal;

    public RegexLineMatcher(String regex) {
        this(Pattern.compile(regex));
    }

    public RegexLineMatcher(Pattern regex) {
        this(regex, false);
    }

    public RegexLineMatcher(Pattern regex, boolean matchOriginal) {
        this.regex = regex;
        this.matchOriginal = matchOriginal;
    }

    @Override
    public final void process(Line line, Emitter<T> emitter) throws Exception {
        RegexMatcher matcher = line.match(this.regex);
        if (!matcher.matches()) {
            return;
        }
        T event = this.fromMatch(line, matcher);
        if (event != null) {
            emitter.fire(event);
        }
    }

    public abstract T fromMatch(Line var1, RegexMatcher var2) throws Exception;
}

