/*
 * Decompiled with CFR 0.152.
 */
package com.azul.java;

public final class NameUtils {
    private NameUtils() {
    }

    public static String toVmName(String className) {
        return className.replace('.', '/');
    }

    public static String toJavaName(String className) {
        return className.replace('/', '.');
    }

    public static String logicalPackageOf(String classOrMethod) {
        String cls;
        switch (cls = NameUtils.classOf(classOrMethod)) {
            case "java.util.Calendar": 
            case "java.util.Date": {
                return "*java.util.Calendar*";
            }
            case "java.lang.Boolean": 
            case "java.lang.Character": 
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Integer$IntegerCache": 
            case "java.lang.Long": 
            case "java.lang.Long$LongCache": 
            case "java.lang.Float": 
            case "java.lang.Double": {
                return "*java.lang.Boxes*";
            }
            case "java.lang.Package": 
            case "java.lang.ClassNotFoundException": 
            case "java.lang.IllegalAccessException": 
            case "java.lang.InstantiationException": 
            case "java.lang.InvocationTargetException": 
            case "java.lang.NoSuchFieldException": 
            case "java.lnag.NoSuchMethodException": {
                return "*java.lang.reflect*";
            }
            case "java.util.WeakHashMap": {
                return "*java.lang.ref*";
            }
            case "java.math.MutableBigInteger": 
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": {
                return "*java.BigNums*";
            }
            case "java.lang.Math": 
            case "java.lang.StrictMath": {
                return "*java.math*";
            }
        }
        if (cls.startsWith("java.lang.Class") || cls.startsWith("sun.misc.URLClassPath")) {
            return "*java.lang.reflect*";
        }
        if (cls.startsWith("java.lang.ThreadLocal") || cls.equals("java.lang.InheritableThreadLocal")) {
            return "*java.lang.ThreadLocal*";
        }
        if (cls.startsWith("java.lang.Process") || cls.startsWith("java.lang.UNIXProcess")) {
            return "*java.lang.Process*";
        }
        if (cls.startsWith("java.lang.String") || cls.startsWith("java.lang.Char") || cls.equals("java.lang.AbstractStringBuilder")) {
            return "*java.lang.StringBuilding*";
        }
        if (cls.contains("ClassLoader")) {
            return "*ClassLoader*";
        }
        if (cls.startsWith("java.util.Formatter")) {
            return "*java.text*";
        }
        if (cls.startsWith("sun.misc.ProxyGenerator")) {
            return "*java.lang.reflect*";
        }
        String logicalPkg = NameUtils.logicalPackage(NameUtils.packageOf(classOrMethod));
        if (logicalPkg.equals("java.lang")) {
            if (NameUtils.isProbablyThrowable(cls)) {
                return "*java.lang.Throwables*";
            }
            return "*java.lang*";
        }
        if (logicalPkg.equals("sun.misc")) {
            return "*sun.misc*";
        }
        return logicalPkg;
    }

    private static String logicalPackage(String pkg) {
        if (pkg.equals("sun.util.calendar")) {
            return "*java.util.Calendar*";
        }
        if (pkg.startsWith("java.util.concurrent")) {
            return "*java.util.concurrent*";
        }
        if (pkg.equals("java.util.jar") || pkg.equals("sun.net.www.protocol.jar")) {
            return "*java.util.jar*";
        }
        if (pkg.equals("java.nio.charset") || pkg.equals("sun.nio.cs")) {
            return "*java.nio.charset*";
        }
        if (pkg.startsWith("java.nio") || pkg.startsWith("sun.nio")) {
            return "*java.nio*";
        }
        if (pkg.startsWith("java.security") || pkg.startsWith("sun.security")) {
            return "*java.security*";
        }
        if (pkg.contains(".jdbc")) {
            return "*jdbc*";
        }
        if (pkg.startsWith("com.sun.org.apache.xerces")) {
            return "*jdk.xerces*";
        }
        if (pkg.startsWith("sun.net.www")) {
            return "*sun.net.www*";
        }
        if (pkg.equals("java.lang.reflect") || pkg.equals("java.beans")) {
            return "*java.lang.reflect*";
        }
        if (pkg.startsWith("sun.reflect") || pkg.equals("com.sun.beans")) {
            return "*java.lang.reflect*";
        }
        if (pkg.startsWith("org.xml.sax")) {
            return "*org.xml.sax*";
        }
        if (pkg.equals("java.lang.ref")) {
            return "*java.lang.ref*";
        }
        if (pkg.equals("java.math")) {
            return "*java.math*";
        }
        if (pkg.equals("java.text")) {
            return "*java.text*";
        }
        return pkg;
    }

    public static boolean isProbablyThrowable(String className) {
        String simpleName = NameUtils.simpleNameOf(className);
        return simpleName.endsWith("Throwable") || simpleName.endsWith("Exception") || simpleName.endsWith("Error");
    }

    public static String classOf(String classOrMethod) {
        int colonPos = classOrMethod.indexOf("::");
        if (colonPos == -1) {
            return classOrMethod;
        }
        return classOrMethod.substring(0, colonPos);
    }

    public static String shortNameOf(String classOrMethod) {
        return NameUtils.simpleNameOf(classOrMethod);
    }

    public static String simpleNameOf(String classOrMethod) {
        int lastColonPos = classOrMethod.lastIndexOf("::");
        if (lastColonPos != -1) {
            return classOrMethod.substring(lastColonPos + 2);
        }
        int lastDotPos = classOrMethod.lastIndexOf(46);
        if (lastDotPos != -1) {
            return classOrMethod.substring(lastDotPos + 1);
        }
        return classOrMethod;
    }

    public static String packageOf(String classOrMethod) {
        if (classOrMethod.contains("::")) {
            return NameUtils.packageOfClass(NameUtils.classOf(classOrMethod));
        }
        return NameUtils.packageOfClass(classOrMethod);
    }

    private static String packageOfClass(String className) {
        int lastDotPos = className.lastIndexOf(46);
        if (lastDotPos == -1) {
            return "default package";
        }
        return className.substring(0, lastDotPos);
    }
}

