/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.codeprofile;

import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.method.PersistentMethodId;
import java.util.Objects;

public abstract class CodeProfileId {
    private CodeProfileId() {
    }

    public static CodeProfileId of(long id) {
        return new New(id);
    }

    public static CodeProfileId of(PersistentMethodId methodId, CompilationId compileId) {
        return new Old(methodId, compileId);
    }

    public static CodeProfileId of(Long profileId, PersistentMethodId methodId, CompilationId compileId) {
        if (profileId != null && methodId == null && compileId == null) {
            return CodeProfileId.of(profileId);
        }
        if (methodId != null && compileId != null && profileId == null) {
            return CodeProfileId.of(methodId, compileId);
        }
        throw new IllegalArgumentException("Unsupported combination of CodeProfile identifiers: " + profileId + ", " + methodId + ", " + compileId);
    }

    private static class Old
    extends CodeProfileId {
        private final long methodId;
        private final int compileId;

        Old(PersistentMethodId methodId, CompilationId compileId) {
            this.methodId = methodId.longValue();
            this.compileId = compileId.intValue();
        }

        public String toString() {
            return this.methodId + "-" + this.compileId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.getClass() != Old.class) {
                return false;
            }
            Old that = (Old)o;
            return this.methodId == that.methodId && this.compileId == that.compileId;
        }

        public int hashCode() {
            return Objects.hash(this.methodId, this.compileId);
        }
    }

    private static class New
    extends CodeProfileId {
        private final long id;

        New(long id) {
            this.id = id;
        }

        public String toString() {
            return Long.toString(this.id);
        }

        public boolean equals(Object o) {
            return o instanceof New && ((New)o).id == this.id;
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }
    }
}

