/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.deopt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum DeoptReason {
    UNKNOWN("unknown"),
    BAD("BAD"),
    DEOPT("deoptimization"),
    UNLOADED("unloaded"),
    UNREACHED("unreached"),
    UNREACHED_IF("unreached_if"),
    UNREACHED_CALL("unreached_call"),
    ATHROW("athrow"),
    NULL_CHECK("null_check"),
    DIV0_CHECK("div0_check"),
    RANGE_CHECK("range_check"),
    RANGE_CHECK_WIDENED("range_check_widened"),
    CAST_CHECK("cast_check"),
    UNHANDLED("unhandled"),
    ARRAY_STORE_CHECK("array_store_check"),
    UNINITIALIZED("uninitialized"),
    UNLOADED_ARRAY_CLASS("unloaded_array_class"),
    UNEXPECTED_KLASS("unexpected_klass"),
    UNEXPECTED_KLASS_MONO("unexpected_klass_mono"),
    UNEXPECTED_KLASS_BI("unexpected_klass_bi"),
    UNEXPECTED_KLASS_TRI("unexpected_klass_tri"),
    UNEXPECTED_NULL_CAST("unexpected_null_cast"),
    INTRINSIC_CHECK("intrinsic_check"),
    INSTALL_ASYNC_EX("install_async_ex"),
    NEW_EXCEPTION("new_exception"),
    JVMTI("jvmti"),
    STATIC_IN_CLINIT("static_in_clinit"),
    STUCK_IN_LOOP("stuck_in_loop", true),
    FAST_INTRINSIC_CHECK("Reason_fast_intrinsic_check"),
    C1_PATCH_VOLATILE_FIELD("c1_patch_volatile_field"),
    TOO_MANY_COMPILES("too_many_compiles", true),
    UNCOUNTED_LOOP_SPECULATION("uncounted_loop_speculation_failed"),
    DEOPT_A_LOT("deopt_a_lot", true),
    DEOPT_NOW("deopt now", true),
    DEOPT_C1_NOW("deopt c1 now", true),
    DEOPT_C2_NOW("deopt c2 now", true);

    public final String vmName;
    public final boolean classifyIgnore;

    public static DeoptReason fromVmName(String vmName) {
        DeoptReason reason = DeoptReason.fromVmNameImpl(vmName);
        if (reason == null) {
            throw new IllegalArgumentException("Unknown deopt reason: " + vmName);
        }
        return reason;
    }

    public static DeoptReason fromVmNameOrUnknown(String vmName) {
        DeoptReason reason = DeoptReason.fromVmNameImpl(vmName);
        return reason == null ? UNKNOWN : reason;
    }

    private static DeoptReason fromVmNameImpl(String vmName) {
        for (DeoptReason reason : DeoptReason.values()) {
            if (!reason.vmName.equals(vmName)) continue;
            return reason;
        }
        return null;
    }

    public static List<? extends DeoptReason> classificationReasons() {
        DeoptReason[] allReasons = DeoptReason.values();
        ArrayList<DeoptReason> classificationReasons = new ArrayList<DeoptReason>(allReasons.length);
        for (DeoptReason reason : allReasons) {
            if (reason.classifyIgnore) continue;
            classificationReasons.add(reason);
        }
        return Collections.unmodifiableList(classificationReasons);
    }

    private DeoptReason(String vmName) {
        this(vmName, false);
    }

    private DeoptReason(String vmName, boolean ignore) {
        this.vmName = vmName;
        this.classifyIgnore = ignore;
    }

    public final String toString() {
        return this.vmName;
    }
}

