/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.deopt;

import com.azul.jvm.MemoryAddress;
import com.azul.jvm.Opcode;
import com.azul.jvm.ThreadId;
import com.azul.jvm.VmEvent;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.DeoptAction;
import com.azul.jvm.deopt.DeoptReason;
import com.azul.jvm.deopt.StackFrame;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.method.ByteCodeIndex;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.VmTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class UncommonTrap
implements VmEvent {
    private final UncommonTrapId id;
    protected VmTime time;
    protected String methodName;
    protected MemoryAddress address;
    protected ThreadId threadId;
    protected String reasonStr;
    protected DeoptReason reason;
    protected CompilationId compilationId;
    protected PersistentMethodId methodId;
    protected DeoptAction action;
    protected List<StackFrame> frameRepacks;

    public UncommonTrap(UncommonTrapId id) {
        this.id = Objects.requireNonNull(id, "id");
        this.frameRepacks = new ArrayList<StackFrame>();
    }

    @Override
    public VmTime time() {
        return this.time;
    }

    public UncommonTrapId id() {
        return this.id;
    }

    public String methodName() {
        return this.methodName;
    }

    public MemoryAddress address() {
        return this.address;
    }

    public ThreadId thread() {
        return this.threadId;
    }

    public String reasonStr() {
        return this.reasonStr;
    }

    public DeoptReason reason() {
        return this.reason;
    }

    public CompilationId compilationId() {
        return this.compilationId;
    }

    public PersistentMethodId methodId() {
        return this.methodId;
    }

    public DeoptAction action() {
        return this.action;
    }

    public Stream<StackFrame> frameRepacks() {
        return this.frameRepacks.stream();
    }

    public ByteCodeIndex bci() {
        return this.frameRepacks.isEmpty() ? null : this.frameRepacks.get((int)0).bci;
    }

    public Opcode opcode() {
        return this.frameRepacks.isEmpty() ? null : this.frameRepacks.get((int)0).opcode;
    }
}

