/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.deopt;

import com.azul.jvm.MemoryAddress;
import com.azul.jvm.ThreadId;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.DeoptAction;
import com.azul.jvm.deopt.DeoptReason;
import com.azul.jvm.deopt.StackFrame;
import com.azul.jvm.deopt.StackFrameBuilder;
import com.azul.jvm.deopt.UncommonTrap;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.VmTime;
import java.util.ArrayList;
import java.util.List;

public class UncommonTrapBuilder
extends UncommonTrap {
    public UncommonTrapBuilder(UncommonTrapId id) {
        super(id);
    }

    public UncommonTrapBuilder setTime(VmTime time) {
        this.time = time;
        return this;
    }

    public UncommonTrapBuilder setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public UncommonTrapBuilder setAddress(MemoryAddress address) {
        this.address = address;
        return this;
    }

    public UncommonTrapBuilder setThreadId(ThreadId threadId) {
        this.threadId = threadId;
        return this;
    }

    public UncommonTrapBuilder setReasonStr(String reasonStr) {
        this.reasonStr = reasonStr;
        return this;
    }

    public UncommonTrapBuilder setReason(DeoptReason reason) {
        this.reason = reason;
        return this;
    }

    public UncommonTrapBuilder setCompilationId(CompilationId compilationId) {
        this.compilationId = compilationId;
        return this;
    }

    public UncommonTrapBuilder setMethodId(PersistentMethodId methodId) {
        this.methodId = methodId;
        return this;
    }

    public UncommonTrapBuilder setAction(DeoptAction action) {
        this.action = action;
        return this;
    }

    public UncommonTrapBuilder setFrameRepacks(List<? extends StackFrame> frameRepacks) {
        this.frameRepacks = new ArrayList(frameRepacks.size());
        for (StackFrame stackFrame : frameRepacks) {
            this.frameRepacks.add(stackFrame instanceof StackFrameBuilder ? stackFrame : StackFrameBuilder.copyOf(stackFrame));
        }
        return this;
    }

    public List<StackFrameBuilder> getMutableFrameRepacks() {
        return this.frameRepacks;
    }
}

